/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import com.xdja.ra.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    protected static final Logger logger = LoggerFactory.getLogger(ZipUtils.class);

    public static byte[] createZipByFile(String srcSource, String fileName) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        File file = new File(srcSource);
        ZipUtils.make(zip, file, fileName);
        IOUtils.closeQuietly((Closeable)zip);
        return outputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void make(ZipOutputStream zip, File file, String dir) throws Exception {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                ZipUtils.make(zip, files[i], files[i].getName());
            }
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fileInputStream);
            try {
                ZipEntry entry = new ZipEntry(dir);
                zip.putNextEntry(entry);
                zip.write(FileUtils.readByBinary(file.getPath()));
                IOUtils.closeQuietly((Closeable)bis);
                zip.flush();
                zip.closeEntry();
            }
            catch (Exception e) {
                logger.error("\u4e0b\u8f7dzip\u5f02\u5e38", (Throwable)e);
            }
            finally {
                try {
                    bis.close();
                }
                catch (Exception e) {
                    logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38 ", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateZipFile(List<Map<String, Object>> bytes, String strZipName) throws Exception {
        ZipArchiveOutputStream zous;
        Object out = null;
        File desFile = new File(strZipName);
        if (!desFile.exists()) {
            desFile.getParentFile().mkdirs();
            if (!desFile.createNewFile()) {
                logger.error("\u521b\u5efa\u6587\u4ef6\u5f02\u5e38", (Throwable)new Exception("\u521b\u5efa\u6587\u4ef6\u5f02\u5e38"));
            }
        }
        if ((zous = new ZipArchiveOutputStream(desFile)) instanceof ZipArchiveOutputStream) {
            zous.setEncoding("GBK");
        }
        try {
            zous.setUseZip64(Zip64Mode.AsNeeded);
            for (int i = 0; i < bytes.size(); ++i) {
                String name = (String)bytes.get(i).get("name");
                String suffix = (String)bytes.get(i).get("suffix");
                byte[] by = (byte[])bytes.get(i).get("buffer");
                String filename = name + "." + suffix;
                ZipArchiveEntry entry = new ZipArchiveEntry(filename);
                zous.putArchiveEntry((ArchiveEntry)entry);
                zous.write(by);
                zous.closeArchiveEntry();
            }
        }
        catch (Exception e) {
            logger.error("\u751f\u6210zip\u538b\u7f29\u5305\u4fdd\u5b58", (Throwable)e);
        }
        finally {
            try {
                zous.close();
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public static byte[] generateZipByte(List<Map<String, Object>> bytes) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (ZipOutputStream out = null;){
            out = new ZipOutputStream(outputStream);
            for (int i = 0; i < bytes.size(); ++i) {
                String name = (String)bytes.get(i).get("name");
                String suffix = (String)bytes.get(i).get("suffix");
                byte[] by = (byte[])bytes.get(i).get("buffer");
                String filename = name + "." + suffix;
                ZipArchiveEntry entry = new ZipArchiveEntry(filename);
                out.putNextEntry(new ZipEntry(name + "." + suffix));
                out.write(by);
                out.closeEntry();
                out.flush();
            }
        }
        return outputStream.toByteArray();
    }
}

