/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.deviceuser.bean;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceInfo;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceUserInfo;
import com.xdja.pki.ra.service.manager.deviceuser.bean.UserInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String checkID = "\\d{17}[0-9xX]";
    private String checkPhon = "^(13|14|15|16|17|18|19)[0-9]{9}$";
    private static String checkEmail = "^([a-z0-9A-Z]+[_|-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    private String checkPostCode = "[1-9]\\d{5}";
    private String checkIp = "((25[0-5])|(2[0-4]d)|(1dd)|([1-9]d)|d)(.((25[0-5])|(2[0-4]d)|(1dd)|([1-9]d)|d)){3}";
    private String checkDomain = "[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+.?";
    private String checkPassPort = "^[A-Za-z0-9]{9}$";
    private String checkOfficers = "\\d{7}";
    public static final String SYSTEM_FLAG = "^(?=.*[0-9])(?=.*[a-zA-Z])(.{5,15})$";

    public Result checkFormat(ArrayList<String> list) {
        StringBuffer error = new StringBuffer();
        Result result = new Result();
        result.setCode(0);
        block15: for (int j = 0; j < list.size(); ++j) {
            switch (j) {
                case 0: {
                    if (list.get(0).isEmpty()) {
                        this.logger.info("\u8bbe\u5907\u540d\u4e3a\u7a7a");
                        error = error.append("\u8bbe\u5907\u540d\u4e3a\u7a7a\uff0c");
                        result.setCode(1);
                        continue block15;
                    }
                    if (list.get(0).length() <= 30) continue block15;
                    this.logger.info("\u8bbe\u5907\u540d\u79f0\u683c\u5f0f\u4e0d\u6b63\u786e");
                    error = error.append("\u8bbe\u5907\u540d\u79f0\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block15;
                }
                case 1: {
                    if (StringUtils.isBlank((CharSequence)list.get(1))) {
                        this.logger.info("\u8bbe\u5907\u7c7b\u578b\u4e3a\u7a7a");
                        error = error.append("\u8bbe\u5907\u7c7b\u578b\u4e3a\u7a7a\uff0c");
                        result.setCode(1);
                        continue block15;
                    }
                    if (DeviceUtils.checkDeviceType(list.get(1))) continue block15;
                    this.logger.info("\u8bbe\u5907\u7c7b\u578b\u683c\u5f0f\u4e0d\u6b63\u786e");
                    error = error.append("\u8bbe\u5907\u7c7b\u578b\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block15;
                }
                case 2: {
                    if (StringUtils.isBlank((CharSequence)list.get(2))) {
                        this.logger.info("\u8bbe\u5907\u552f\u4e00\u6807\u8bc6\u7b26\u7a7a");
                        error = error.append("\u8bbe\u5907\u552f\u4e00\u6807\u8bc6\u7b26\u4e3a\u7a7a,");
                        result.setCode(1);
                        continue block15;
                    }
                    if (list.get(2).length() <= 60) continue block15;
                    this.logger.info("\u8bbe\u5907\u552f\u4e00\u6807\u8bc6\u7b26\u683c\u5f0f\u4e0d\u6b63\u786e");
                    error = error.append("\u8bbe\u5907\u552f\u4e00\u6807\u8bc6\u7b26\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block15;
                }
                case 4: {
                    if (list.get(4).length() <= 30) continue block15;
                    this.logger.info("\u59d3\u540d\u683c\u5f0f\u4e0d\u6b63\u786e");
                    error = error.append("\u59d3\u540d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block15;
                }
                case 5: {
                    if (DeviceUtils.checkSex(list.get(5))) continue block15;
                    this.logger.info("\u6027\u522b\u683c\u5f0f\u4e0d\u6b63\u786e");
                    error = error.append("\u6027\u522b\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block15;
                }
                case 6: {
                    if (DeviceUtils.checkIdType(list.get(6))) continue block15;
                    this.logger.info("\u8bc1\u4ef6\u7c7b\u578b\u683c\u5f0f\u4e0d\u6b63\u786e");
                    error = error.append("\u8bc1\u4ef6\u7c7b\u578b\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block15;
                }
                case 7: {
                    if (this.checkIdentifier(list.get(6), list.get(7))) continue block15;
                    this.logger.info("\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
                    error = error.append("\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block15;
                }
                case 8: {
                    if (DeviceUtils.isCheck2(list.get(8), this.checkPhon)) continue block15;
                    this.logger.info("\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e");
                    error = error.append("\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e,");
                    result.setCode(1);
                    continue block15;
                }
                case 9: {
                    if (list.get(9).length() <= 100) continue block15;
                    this.logger.info("\u8054\u7cfb\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e");
                    error = error.append("\u8054\u7cfb\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block15;
                }
                case 10: {
                    if (DeviceUtils.isCheck2(list.get(10), checkEmail) && list.get(10).length() <= 30) continue block15;
                    this.logger.info("\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e");
                    error = error.append("\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block15;
                }
                case 11: {
                    if (DeviceUtils.isCheck2(list.get(11), this.checkPostCode)) continue block15;
                    this.logger.info("\u90ae\u7f16\u683c\u5f0f\u4e0d\u6b63\u786e");
                    error = error.append("\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block15;
                }
                case 12: {
                    if (list.get(12).length() <= 100) continue block15;
                    this.logger.error("\u5907\u6ce8\u683c\u5f0f\u4e0d\u6b63\u786e");
                    error = error.append("\u5907\u6ce8\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block15;
                }
                case 13: {
                    if (list.get(13).length() <= 30) continue block15;
                    this.logger.error("\u6240\u5c5e\u7cfb\u7edf\u683c\u5f0f\u4e0d\u6b63\u786e");
                    error = error.append("\u6240\u5c5e\u7cfb\u7edf\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block15;
                }
            }
        }
        if (error.length() > 0) {
            StringBuffer stringBuffer = error.deleteCharAt(error.length() - 1);
            list.add(stringBuffer.toString());
        }
        result.setInfo(list);
        return result;
    }

    public static DeviceInfo format(List<String> list) {
        DeviceInfo deviceInfo = new DeviceInfo();
        DeviceUserInfo deviceUserInfo = new DeviceUserInfo();
        UserInfo userInfo = new UserInfo();
        deviceUserInfo.setUserName(list.get(0));
        switch (list.get(1)) {
            case "\u670d\u52a1\u5668": {
                deviceUserInfo.setLicenseType(1);
                break;
            }
            case "\u624b\u673a": {
                deviceUserInfo.setLicenseType(2);
                break;
            }
            case "\u7f51\u7ad9": {
                deviceUserInfo.setLicenseType(3);
                break;
            }
            case "\u8f66\u673a": {
                deviceUserInfo.setLicenseType(6);
                break;
            }
            case "T-BOX": {
                deviceUserInfo.setLicenseType(5);
                break;
            }
            case "\u5176\u4ed6": {
                deviceUserInfo.setLicenseType(4);
                break;
            }
        }
        deviceUserInfo.setLicenseNumber(list.get(2));
        deviceUserInfo.setDeviceDesc(list.get(3));
        userInfo.setPersonName(list.get(4));
        switch (list.get(5)) {
            case "\u7537": {
                userInfo.setSex(1);
                break;
            }
            case "\u5973": {
                userInfo.setSex(2);
                break;
            }
            default: {
                userInfo.setSex(0);
            }
        }
        switch (list.get(6)) {
            case "\u8eab\u4efd\u8bc1": {
                userInfo.setLicenseType(1);
                break;
            }
            case "\u519b\u5b98\u8bc1": {
                userInfo.setLicenseType(2);
                break;
            }
            case "\u62a4\u7167": {
                userInfo.setLicenseType(3);
                break;
            }
            case "\u5176\u4ed6": {
                userInfo.setLicenseType(4);
                break;
            }
        }
        userInfo.setLicenseNumber(list.get(7));
        userInfo.setTelNumber(list.get(8));
        userInfo.setAddress(list.get(9));
        userInfo.setEmail(list.get(10));
        userInfo.setPostalCode(list.get(11));
        userInfo.setRemark(list.get(12));
        deviceUserInfo.setSystemName(list.get(13));
        deviceInfo.setDeviceUserInfo(deviceUserInfo);
        deviceInfo.setUserInfo(userInfo);
        return deviceInfo;
    }

    public static boolean checkSex(String sex) {
        return sex.equals("\u5973") || sex.equals("\u7537") || StringUtils.isBlank((CharSequence)sex);
    }

    public boolean checkOfficers(String office) {
        if ("\u519b".equals(office.substring(0, 1)) && office.length() == 8) {
            return DeviceUtils.isCheck(office.substring(1), this.checkOfficers);
        }
        return false;
    }

    public boolean checkIdentifier(String mobiles, String authen) {
        if (StringUtils.isBlank((CharSequence)authen)) {
            return true;
        }
        boolean authenticity = false;
        switch (mobiles) {
            case "\u7f51\u7ad9": {
                authenticity = DeviceUtils.isCheck(authen, this.checkDomain);
                break;
            }
            case "\u624b\u673a": {
                authenticity = DeviceUtils.isCheck(authen, this.checkPhon);
                break;
            }
            case "\u670d\u52a1\u5668": {
                authenticity = DeviceUtils.isCheck(authen, this.checkIp);
                break;
            }
            case "\u8eab\u4efd\u8bc1": {
                authenticity = DeviceUtils.isCheck(authen, this.checkID);
                break;
            }
            case "\u62a4\u7167": {
                authenticity = DeviceUtils.isCheck(authen, this.checkPassPort);
                break;
            }
            case "\u519b\u5b98\u8bc1": {
                authenticity = this.checkOfficers(authen);
                break;
            }
            case "\u5176\u4ed6": {
                authenticity = true;
                break;
            }
        }
        return authenticity;
    }

    public static boolean checkDeviceType(String type) {
        return "\u670d\u52a1\u5668".equals(type) | "\u624b\u673a".equals(type) | "\u7f51\u7ad9".equals(type) | "\u5176\u4ed6".equals(type) || "\u8f66\u673a".equals(type) || "T-BOX".equals(type);
    }

    public static boolean checkIdType(String type) {
        return StringUtils.isBlank((CharSequence)type) || type.equals("\u8eab\u4efd\u8bc1") || type.equals("\u519b\u5b98\u8bc1") || type.equals("\u62a4\u7167") || type.equals("\u5176\u4ed6");
    }

    public static boolean isCheck2(String param, String pattern) {
        if (StringUtils.isBlank((CharSequence)param)) {
            return true;
        }
        return Pattern.matches(pattern, param);
    }

    public static boolean isCheck(String mobiles, String check) {
        boolean matches = Pattern.matches(check, mobiles);
        return matches;
    }

    public static void main(String[] args) {
        boolean ss = DeviceUtils.isCheck("it_helpdesk@ai-ways.com", checkEmail);
        System.out.println(ss);
    }
}

