/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.organuser.bean;

import com.xdja.pki.ra.core.common.Result;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganParamsCheck {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ID_NUMBER_PATTERN = "\\d{17}[0-9xX]";
    private static final String JUNGUAN_NUMBER_PATTERN = "\\d{7}";
    public static final String PASSPORT_NUMBER_PATTERN = "^[A-Za-z0-9]{9}$";
    public static final String EMAIL_NUMBER_PATTERN = "^([a-z0-9A-Z]+[_|-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    public static final String POSTALCODE_NUMBER_PATTERN = "[1-9]\\d{5}";
    public static final String TELNUMBER_NUMBER_PATTERN = "^(13|14|15|16|17|18|19)[0-9]{9}$";
    public static final String ORGAN_NUMBER_PATTERN = "^.{1,30}$";
    public static final String SYSTEM_FLAG = "^(?=.*[0-9])(?=.*[a-zA-Z])(.{5,15})$";

    public Result checkOrganParams(ArrayList<String> list) {
        Result result = new Result();
        result.setCode(0);
        StringBuffer stringBuffer = new StringBuffer();
        block19: for (int i = 0; i < list.size(); ++i) {
            switch (i) {
                case 0: {
                    if (list.get(0) == null || list.get(0).isEmpty()) {
                        this.logger.error("\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                        stringBuffer = stringBuffer.append("\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c");
                        result.setCode(1);
                        continue block19;
                    }
                    if (list.get(0).length() <= 30) continue block19;
                    this.logger.error("\u673a\u6784\u540d\u79f0\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u673a\u6784\u540d\u79f0\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 1: {
                    if (list.get(1).length() <= 30) continue block19;
                    this.logger.error("\u673a\u6784\u6cd5\u4eba\u4ee3\u8868\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u673a\u6784\u6cd5\u4eba\u4ee3\u8868\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 2: {
                    if (list.get(2) == null || list.get(2).isEmpty()) {
                        this.logger.error("\u673a\u6784\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                        stringBuffer = stringBuffer.append("\u673a\u6784\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c");
                        result.setCode(1);
                        continue block19;
                    }
                    if (list.get(2).equals("\u4f01\u4e1a\u5de5\u5546\u6ce8\u518c\u53f7") || list.get(2).equals("\u4f01\u4e1a\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801") || list.get(2).equals("\u4f01\u4e1a\u7a0e\u53f7") || list.get(2).equals("\u5176\u4ed6")) continue block19;
                    this.logger.error("\u673a\u6784\u8bc1\u4ef6\u7c7b\u578b\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u673a\u6784\u8bc1\u4ef6\u7c7b\u578b\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 3: {
                    if (list.get(3) == null || list.get(3).isEmpty()) {
                        this.logger.error("\u673a\u6784\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        stringBuffer = stringBuffer.append("\u673a\u6784\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c");
                        result.setCode(1);
                        continue block19;
                    }
                    if (OrganParamsCheck.isCheck(ORGAN_NUMBER_PATTERN, list.get(3))) continue block19;
                    this.logger.error("\u673a\u6784\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u673a\u6784\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 4: {
                    if (list.get(4).length() <= 100) continue block19;
                    this.logger.error("\u673a\u6784\u8054\u7cfb\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u673a\u6784\u8054\u7cfb\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 5: {
                    if (OrganParamsCheck.isCheck2(EMAIL_NUMBER_PATTERN, list.get(5)) && list.get(5).length() <= 30) continue block19;
                    this.logger.error("\u673a\u6784\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u673a\u6784\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 6: {
                    if (OrganParamsCheck.isCheck2(POSTALCODE_NUMBER_PATTERN, list.get(6))) continue block19;
                    this.logger.error("\u673a\u6784\u90ae\u7f16\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u673a\u6784\u90ae\u7f16\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 7: {
                    if (list.get(7).length() <= 30) continue block19;
                    this.logger.error("\u8054\u7cfb\u4eba\u59d3\u540d\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u8054\u7cfb\u4eba\u59d3\u540d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 8: {
                    if (OrganParamsCheck.checkSex(list.get(8))) continue block19;
                    this.logger.error("\u8054\u7cfb\u4eba\u6027\u522b\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u8054\u7cfb\u4eba\u6027\u522b\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 9: {
                    if (!StringUtils.isNotBlank((CharSequence)list.get(9)) || list.get(9).equals("\u8eab\u4efd\u8bc1") || list.get(9).equals("\u519b\u5b98\u8bc1") || list.get(9).equals("\u62a4\u7167") || list.get(9).equals("\u5176\u4ed6")) continue block19;
                    this.logger.error("\u8054\u7cfb\u4eba\u8bc1\u4ef6\u7c7b\u578b\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u8054\u7cfb\u4eba\u8bc1\u4ef6\u7c7b\u578b\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 10: {
                    if (this.checkLicenseNumber(list.get(9), list.get(10)).booleanValue()) continue block19;
                    this.logger.error("\u8054\u7cfb\u4eba\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u8054\u7cfb\u4eba\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 11: {
                    if (OrganParamsCheck.isCheck2(TELNUMBER_NUMBER_PATTERN, list.get(11))) continue block19;
                    this.logger.error("\u8054\u7cfb\u4eba\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u8054\u7cfb\u4eba\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 12: {
                    if (list.get(12).length() <= 100) continue block19;
                    this.logger.error("\u8054\u7cfb\u4eba\u8054\u7cfb\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u8054\u7cfb\u4eba\u8054\u7cfb\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 13: {
                    if (OrganParamsCheck.isCheck2(EMAIL_NUMBER_PATTERN, list.get(13)) && list.get(13).length() <= 30) continue block19;
                    this.logger.error("\u8054\u7cfb\u4eba\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u8054\u7cfb\u4eba\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 14: {
                    if (OrganParamsCheck.isCheck2(POSTALCODE_NUMBER_PATTERN, list.get(14))) continue block19;
                    this.logger.error("\u8054\u7cfb\u4eba\u90ae\u7f16\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u8054\u7cfb\u4eba\u90ae\u7f16\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 15: {
                    if (list.get(15).length() <= 100) continue block19;
                    this.logger.error("\u8054\u7cfb\u4eba\u5907\u6ce8\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u8054\u7cfb\u4eba\u5907\u6ce8\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
                case 16: {
                    if (list.get(16).length() <= 30) continue block19;
                    this.logger.error("\u6240\u5c5e\u7cfb\u7edf\u683c\u5f0f\u4e0d\u6b63\u786e");
                    stringBuffer = stringBuffer.append("\u6240\u5c5e\u7cfb\u7edf\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                    result.setCode(1);
                    continue block19;
                }
            }
        }
        if (stringBuffer.length() > 0) {
            String substring = stringBuffer.substring(0, stringBuffer.length() - 1);
            list.add(substring);
        }
        result.setInfo(list);
        return result;
    }

    public static boolean isCheck(String pattern, String param) {
        boolean matches = Pattern.matches(pattern, param);
        return matches;
    }

    public static boolean isCheck2(String pattern, String param) {
        if (StringUtils.isBlank((CharSequence)param)) {
            return true;
        }
        return Pattern.matches(pattern, param);
    }

    public static boolean checkSex(String sex) {
        return StringUtils.isBlank((CharSequence)sex) || sex.equals("\u5973") | sex.equals("\u7537");
    }

    public Boolean checkLicenseNumber(String licenseType, String licenseNumber) {
        if (licenseType.equals("\u8eab\u4efd\u8bc1")) {
            return OrganParamsCheck.isCheck(ID_NUMBER_PATTERN, licenseNumber);
        }
        if (licenseType.equals("\u519b\u5b98\u8bc1")) {
            if ("\u519b".equals(licenseNumber.substring(0, 1)) && licenseNumber.length() == 8) {
                return OrganParamsCheck.isCheck(JUNGUAN_NUMBER_PATTERN, licenseNumber.substring(1));
            }
            return false;
        }
        if (licenseType.equals("\u62a4\u7167")) {
            return OrganParamsCheck.isCheck(PASSPORT_NUMBER_PATTERN, licenseNumber);
        }
        if (licenseType.equals("\u5176\u4ed6")) {
            return true;
        }
        return true;
    }
}

