package com.xdja.pki.ra.service.manager.ak;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.service.manager.ak.xml.request.*;

/**
 * @Author:ggp
 * @Date:2020-08-24 09:08
 * @Description:
 */
public interface AkService {
    /**
     * 用户注册
     * @param userRegisterReq
     * @return
     */
    public Result userRegister(UserRegisterReq userRegisterReq);

    /**
     * 证书申请
     * @param certApplyReq
     * @return
     */
    public Result certApply(CertApplyReq certApplyReq);

    /**
     * 证书下载
     * @param certDownReq
     * @return
     */
    public Result certDown(CertDownReq certDownReq);

    /**
     * 证书更新
     * @param certUpdateReq
     * @return
     */
    public Result certUpdate(CertUpdateReq certUpdateReq);

    /**
     * 证书撤销
     * @param certRevokeReq
     * @return
     */
    public Result certRevoke(CertRevokeReq certRevokeReq);

    /**
     * 秘钥恢复
     * @param keyRestoreReq
     * @return
     */
    public Result keyRestore(KeyRestoreReq keyRestoreReq);

}
