package com.xdja.pki.ra.service.manager.ak.xml.config;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.xdja.pki.core.utils.SpringBeanUtils;
import org.springframework.boot.CommandLineRunner;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.stereotype.Component;

/**
 * @Author:ggp
 * @Date:2020-08-20 16:06
 * @Description:
 */
@Component
public class ConfigXml implements CommandLineRunner {
    @Override
    public void run(String... strings) throws Exception {
        /**
         * 配置xml序列化版本号和字符集
         */
        MappingJackson2XmlHttpMessageConverter converter = SpringBeanUtils.getBean(MappingJackson2XmlHttpMessageConverter.class);
        XmlMapper xmlMapper =(XmlMapper) converter.getObjectMapper();
        xmlMapper.enable(ToXmlGenerator.Feature.WRITE_XML_DECLARATION);
        /**
         * 提前加载自定义的类对象，官方定义的是懒加载~
         */
       Class.forName("com.ctc.wstx.sw.BufferingXmlWriter");
    }
}
