package com.xdja.pki.ra.service.manager.baseuser;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.service.manager.baseuser.bean.UserInfo;

/**
 * @author wly
 */
public interface BaseUserService {

    /**
     * 用户注册查询第三方系统标识
     * @return
     */
    Result getAllSystemName();

    /**
     * 根据id 获取base_user用户表信息
     *
     * @param baseId
     * @return
     */
    Result getBaseUser(Long baseId);

    /**
     * 更新用户状态信息 启用/停用
     *
     * @param userId
     * @param status
     * @return
     */

    Result updateUserStatus(Integer userId, int status, boolean isOnline, String systemFlag);

    /**
     * 更新用户状态信息 启用/停用
     *
     * @param userType
     * @param identType
     * @param licenseNumber
     * @param status
     * @param systemFlag
     * @return
     */
    Result updateUserStatus(Integer userType,Integer identType,String licenseNumber,Integer status,String systemFlag);

    /**
     * 用户已存在校验 调用
     *
     * @param licenseType
     * @param licenseNumber
     * @param userType
     * @param systemFlag
     * @return
     */
    int queryUserExist(Integer licenseType, String licenseNumber, Integer userType, String systemFlag);

    /**
     * 用户注册
     * @param userType
     * @param userInfo
     * @param systemFlag
     * @return
     */
    Result userRegister(Integer userType, UserInfo userInfo, String systemFlag);

    /**
     * 用户查询
     *
     * @param userType
     * @param identType
     * @param licenseNumber
     * @param systemFlag
     * @return
     */
    Result userQuery(Integer userType, Integer identType, String licenseNumber,String systemFlag);

    /**
     * 根据签名证书sn查询用户信息
     * @param sn
     * @return
     */
    Result userQuery(String sn,String systemFlag);

    /**
     * 查询用户ID
     * @param userType
     * @param systemFlag
     * @param licenseType
     * @param licenseNumber
     * @return
     */
    Long queryUserId(int userType, String systemFlag, Integer licenseType, String licenseNumber);

    /**
     * 用户更新
     *
     * @param userType
     * @param identType
     * @param licenseNumber
     * @param userInfo
     * @return
     */
    Result userUpdate(Integer userType, Integer identType, String licenseNumber, UserInfo userInfo,String systemFlag);
}
