package com.xdja.pki.ra.service.manager.baseuser.bean;

import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.util.cert.HsmUtils;
import com.xdja.pki.ra.manager.dao.model.ContactUserDO;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceUserVO;
import com.xdja.pki.ra.service.manager.organuser.bean.OrganUserVO;
import com.xdja.pki.ra.service.manager.personuser.bean.PersonUserVO;
import org.apache.commons.lang3.StringUtils;

/**
 * 解密用户信息
 *
 * @author wly
 */
public class DecryptUserInfo {

    /**
     * 单字段解密
     *
     * @return
     */
    public static String getDecryptString(String doDecrypt) throws Exception {
        if (Constants.DATA_IS_ENCRYPTION_1.equals(CommonVariable.getIsEncrypt())) {
            doDecrypt = getDecrypt(doDecrypt);
        }
        return doDecrypt;
    }

    /**
     * 解密
     *
     * @return
     */
    public static String getDecrypt(String doDecrypt) throws Exception {
        return HsmUtils.getDecrypt(doDecrypt);
    }

    /**
     * 个人用户信息解密
     *
     * @param personUserVO
     * @return
     */
    public static PersonUserVO getDecryptPersonUserVO(PersonUserVO personUserVO) throws Exception {
        /***
         * 如果信息数据不解密直接返回
         */
        if (Constants.DATA_NOT_ENCRYPTION_0.equals(CommonVariable.getIsEncrypt())) {
            return personUserVO;
        }
        /**
         * 个人用户信息：联系人姓名、证件号码、联系电话、地址、邮箱
         */
        String telNumber = personUserVO.getTelNumber();
        if (StringUtils.isNotBlank(telNumber)) {
            personUserVO.setTelNumber(getDecrypt(telNumber));
        }
        String licenseNumber = personUserVO.getLicenseNumber();
        if (StringUtils.isNotBlank(licenseNumber)) {
            personUserVO.setLicenseNumber(getDecrypt(licenseNumber));
        }
        String address = personUserVO.getAddress();
        if (StringUtils.isNotBlank(address)) {
            personUserVO.setAddress(getDecrypt(address));
        }
        String email = personUserVO.getEmail();
        if (StringUtils.isNotBlank(email)) {
            personUserVO.setEmail(getDecrypt(email));
        }

        return personUserVO;
    }

    /**
     * 机构用户 信息解密
     *
     * @param organUserVO
     * @return
     */
    public static OrganUserVO getDecryptOrganUserVO(OrganUserVO organUserVO) throws Exception {
        /***
         * 如果信息数据不解密直接返回
         */
        if (Constants.DATA_NOT_ENCRYPTION_0.equals(CommonVariable.getIsEncrypt())) {
            return organUserVO;
        }
        /**
         * 机构信息解密
         * 机构信息：企业证件号码、邮箱
         */
        String licenseNumber = organUserVO.getLicenseNumber();
        organUserVO.setLicenseNumber(getDecrypt(licenseNumber));

        String email = organUserVO.getEmail();
        if (StringUtils.isNotBlank(organUserVO.getEmail())) {
            organUserVO.setEmail(getDecrypt(email));
        }
        /**
         * 机构信息解密
         * 联系人信息：证件号码、联系电话、地址、邮箱
         */
        String personLicenseNumber = organUserVO.getPersonLicenseNumber();
        if (StringUtils.isNotBlank(personLicenseNumber)) {
            organUserVO.setPersonLicenseNumber(getDecrypt(personLicenseNumber));
        }
        String telNumber = organUserVO.getTelNumber();
        if (StringUtils.isNotBlank(telNumber)) {
            organUserVO.setTelNumber(DecryptUserInfo.getDecrypt(telNumber));
        }
        String personAddress = organUserVO.getPersonAddress();
        if (StringUtils.isNotBlank(personAddress)) {
            organUserVO.setPersonAddress(DecryptUserInfo.getDecrypt(personAddress));
        }
        String personEmail = organUserVO.getPersonEmail();
        if (StringUtils.isNotBlank(personEmail)) {
            organUserVO.setPersonEmail(DecryptUserInfo.getDecrypt(personEmail));
        }
        return organUserVO;
    }

    /**
     * 机构用户 信息解密
     *
     * @param deviceUserVO
     * @return
     */
    public static DeviceUserVO getDecryptOrganUserVO(DeviceUserVO deviceUserVO) throws Exception {
        /***
         * 如果信息数据不解密直接返回
         */
        if (Constants.DATA_NOT_ENCRYPTION_0.equals(CommonVariable.getIsEncrypt())) {
            return deviceUserVO;
        }
        /**
         * 机构信息解密
         * 机构信息：企业证件号码、邮箱
         */
        String licenseNumber = deviceUserVO.getLicenseNumber();
        deviceUserVO.setLicenseNumber(getDecrypt(licenseNumber));

        /**
         * 机构信息解密
         * 联系人信息：证件号码、联系电话、地址、邮箱
         */
        String personLicenseNumber = deviceUserVO.getUserLicenseNumber();
        if (StringUtils.isNotBlank(personLicenseNumber)) {
            deviceUserVO.setUserLicenseNumber(getDecrypt(personLicenseNumber));
        }
        String telNumber = deviceUserVO.getTelNumber();
        if (StringUtils.isNotBlank(telNumber)) {
            deviceUserVO.setTelNumber(DecryptUserInfo.getDecrypt(telNumber));
        }
        String address = deviceUserVO.getAddress();
        if (StringUtils.isNotBlank(address)) {
            deviceUserVO.setAddress(DecryptUserInfo.getDecrypt(address));
        }
        String personEmail = deviceUserVO.getEmail();
        if (StringUtils.isNotBlank(personEmail)) {
            deviceUserVO.setEmail(DecryptUserInfo.getDecrypt(personEmail));
        }
        return deviceUserVO;
    }


    /**
     * 机构用户机构信息解密 接口
     *
     * @param organUser
     * @return
     */
    public static OrganUser getDecryptOrganUser(OrganUser organUser) throws Exception {
        /***
         * 如果信息数据不解密直接返回
         */
        if (Constants.DATA_NOT_ENCRYPTION_0.equals(CommonVariable.getIsEncrypt())) {
            return organUser;
        }
        /**
         * 机构信息解密
         * 机构信息：企业证件号码、邮箱
         */
        String licenseNumber = organUser.getLicenseNumber();
        organUser.setLicenseNumber(getDecrypt(licenseNumber));
        String email = organUser.getEmail();
        if (StringUtils.isNotBlank(organUser.getEmail())) {
            organUser.setEmail(getDecrypt(email));
        }

        return organUser;
    }

    /**
     * 联系人/个人用户 信息解密 接口
     *
     * @param personUser
     * @return
     */
    public static PersonUser getDecryptPersonUser(PersonUser personUser) throws Exception {
        if (null == personUser) {
            return null;
        }
        /***
         * 如果信息数据不解密直接返回
         */
        if (Constants.DATA_NOT_ENCRYPTION_0.equals(CommonVariable.getIsEncrypt())) {
            return personUser;
        }
        /**
         * 联系人信息：联系人姓名、证件号码、联系电话、地址、邮箱
         */
        String personLicenseNumber = personUser.getLicenseNumber();
        if (StringUtils.isNotBlank(personLicenseNumber)) {
            personUser.setLicenseNumber(getDecrypt(personLicenseNumber));
        }
        String telNumber = personUser.getTelNumber();
        if (StringUtils.isNotBlank(telNumber)) {
            personUser.setTelNumber(DecryptUserInfo.getDecrypt(telNumber));
        }
        String address = personUser.getAddress();
        if (StringUtils.isNotBlank(address)) {
            personUser.setAddress(DecryptUserInfo.getDecrypt(address));
        }
        String personEmail = personUser.getEmail();
        if (StringUtils.isNotBlank(personEmail)) {
            personUser.setEmail(DecryptUserInfo.getDecrypt(personEmail));
        }

        return personUser;
    }

    /**
     * 设备用户设备信息解密 接口
     *
     * @param deviceUser
     * @return
     */
    public static DeviceUser getDecryptDeviceUser(DeviceUser deviceUser) throws Exception {
        /***
         * 如果信息数据不解密直接返回
         */
        if (Constants.DATA_NOT_ENCRYPTION_0.equals(CommonVariable.getIsEncrypt())) {
            return deviceUser;
        }
        /**
         * 设备信息解密
         * 设备唯一标识符 设备名称
         */
        String licenseNumber = deviceUser.getLicenseNumber();
        deviceUser.setLicenseNumber(getDecrypt(licenseNumber));

        return deviceUser;
    }

    /**
     * 联系人信息解密 （机构、设备用户的联系人）
     *
     * @param contactUserDO
     * @return
     */
    public ContactUserDO getDecryptContactUserDO(ContactUserDO contactUserDO) throws Exception {
        /***
         * 如果联系人信息为空 或 信息数据不解密直接返回
         */
        if (null == contactUserDO || Constants.DATA_NOT_ENCRYPTION_0.equals(CommonVariable.getIsEncrypt())) {
            return contactUserDO;
        }
        /**
         * 联系人信息：证件号码、联系电话、地址、邮箱
         */
        String licenseNumber = contactUserDO.getLicenseNumber();
        if (StringUtils.isNotBlank(licenseNumber)) {
            contactUserDO.setLicenseNumber(getDecrypt(licenseNumber));
        }
        String telNumber = contactUserDO.getTelNumber();
        if (StringUtils.isNotBlank(telNumber)) {
            contactUserDO.setTelNumber(getDecrypt(telNumber));
        }
        String address = contactUserDO.getAddress();
        if (StringUtils.isNotBlank(address)) {
            contactUserDO.setAddress(getDecrypt(address));
        }
        String email = contactUserDO.getEmail();
        if (StringUtils.isNotBlank(email)) {
            contactUserDO.setEmail(getDecrypt(email));
        }
        return contactUserDO;
    }


}
