package com.xdja.pki.ra.service.manager.baseuser.bean;

import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.util.cert.HsmUtils;
import com.xdja.pki.ra.manager.dao.model.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 加密用户信息
 *
 * @author wly
 */
public class EncryptUserInfo {

    /**
     * 单字段加密
     *
     * @return
     */
    public static String getEncryptString(String doEncrypt) throws Exception {
        if(StringUtils.isBlank(doEncrypt)){
            return doEncrypt;
        }
        if (Constants.DATA_IS_ENCRYPTION_1.equals(CommonVariable.getIsEncrypt())) {
            doEncrypt = getEncrypt(doEncrypt);
        }
        return doEncrypt;
    }

    /**
     * 单字段加密
     *
     * @return
     */
    public static String getEncrypt(String doEncrypt) throws Exception {
        return HsmUtils.getEncrypt(doEncrypt);
    }

    /**
     * 个人用户信息加密
     *
     * @param personUserDO
     * @return
     */
    public static PersonUserDO getEncryptPersonUserDO(PersonUserDO personUserDO) throws Exception {
        /***
         * 如果信息数据不加密直接返回
         */
        if (Constants.DATA_NOT_ENCRYPTION_0.equals(CommonVariable.getIsEncrypt())) {
            return personUserDO;
        }
        /**
         * 个人用户信息：证件号码、联系电话、地址、邮箱
         */
        String telNumber = personUserDO.getTelNumber();
        if (StringUtils.isNotBlank(telNumber)) {
            personUserDO.setTelNumber(getEncrypt(telNumber));
        }
        String licenseNumber = personUserDO.getLicenseNumber();
        if (StringUtils.isNotBlank(licenseNumber)) {
            personUserDO.setLicenseNumber(getEncrypt(licenseNumber));
        }
        String address = personUserDO.getAddress();
        if (StringUtils.isNotBlank(address)) {
            personUserDO.setAddress(getEncrypt(address));
        }
        String email = personUserDO.getEmail();
        if (StringUtils.isNotBlank(email)) {
            personUserDO.setEmail(getEncrypt(email));
        }
        return personUserDO;
    }

    /**
     * BaseUserDO信息加密
     *
     * @param baseUserDO
     * @return
     */
    public static BaseUserDO getEncryptBaseUserDO(BaseUserDO baseUserDO) throws Exception {
        /***
         * 如果信息数据不加密直接返回
         * 注册时 先存baseUser 再回显ID存用户表
         */
        if (Constants.DATA_NOT_ENCRYPTION_0.equals(CommonVariable.getIsEncrypt())) {
            return baseUserDO;
        }
        /**
         * 证件号码
         */
        String licenseNumber = baseUserDO.getLicenseNumber();
        baseUserDO.setLicenseNumber(getEncrypt(licenseNumber));

        return baseUserDO;
    }

    /**
     * 机构用户机构信息加密
     *
     * @param organUserDO
     * @return
     */
    public static OrganUserDO getEncryptOrganUserDO(OrganUserDO organUserDO) throws Exception {
        /***
         * 如果信息数据不加密直接返回
         * OrganUserDO 的数据可以直接赋值给 BaseUserDO 更新时
         */
        if (Constants.DATA_NOT_ENCRYPTION_0.equals(CommonVariable.getIsEncrypt())) {
            return organUserDO;
        }
        /**
         * 机构信息 ：企业证件号码、邮箱、机构名称
         */
        String licenseNumber = organUserDO.getLicenseNumber();
        organUserDO.setLicenseNumber(getEncrypt(licenseNumber));
        String email = organUserDO.getEmail();
        if (StringUtils.isNotBlank(email)) {
            organUserDO.setEmail(getEncrypt(email));
        }
        return organUserDO;
    }

    /**
     * 设备用户设备信息加密
     *
     * @param deviceUserDO
     * @return
     */
    public static DeviceUserDO getEncryptDeviceUserDO(DeviceUserDO deviceUserDO) throws Exception {
        /***
         * 如果信息数据不加密直接返回
         * DeviceUserDO 的数据可以直接赋值给 BaseUserDO
         */
        if (Constants.DATA_NOT_ENCRYPTION_0.equals(CommonVariable.getIsEncrypt())) {
            return deviceUserDO;
        }
        /**
         * 设备信息:唯一标识符
         */
        String licenseNumber = deviceUserDO.getLicenseNumber();
        deviceUserDO.setLicenseNumber(getEncrypt(licenseNumber));

        return deviceUserDO;
    }

    /**
     * 联系人信息加密 （机构、设备用户的联系人）
     *
     * @param contactUserDO
     * @return
     */
    public static ContactUserDO getEncryptContactUserDO(ContactUserDO contactUserDO) throws Exception {
        /***
         * 如果联系人信息为空 或 信息数据不加密直接返回
         */
        if (null == contactUserDO || Constants.DATA_NOT_ENCRYPTION_0.equals(CommonVariable.getIsEncrypt())) {
            return contactUserDO;
        }
        /**
         * 联系人信息：证件号码、联系电话、地址、邮箱
         */
        String licenseNumber = contactUserDO.getLicenseNumber();
        if (StringUtils.isNotBlank(licenseNumber)) {
            contactUserDO.setLicenseNumber(getEncrypt(licenseNumber));
        }
        String telNumber = contactUserDO.getTelNumber();
        if (StringUtils.isNotBlank(telNumber)) {
            contactUserDO.setTelNumber(getEncrypt(telNumber));
        }
        String address = contactUserDO.getAddress();
        if (StringUtils.isNotBlank(address)) {
            contactUserDO.setAddress(getEncrypt(address));
        }
        String email = contactUserDO.getEmail();
        if (StringUtils.isNotBlank(email)) {
            contactUserDO.setEmail(getEncrypt(email));
        }
        return contactUserDO;
    }

}
