package com.xdja.pki.ra.service.manager.cache;

/**
 * TransID管理接口
 * <br/>从Redis中存取信息
 * @author wangtf
 * @date 2020年11月19日14:05:25
 */
public interface RedisCacheManagerService {
    /**
     * 保存normal和RA交互时
     * <br/>第三方系统的normalTransId和applyNo的对应关系
     * @param transId 事务ID
     * @param applyNo 申请编号
     * @return Boolean true 成功；false 失败
     */
    Boolean cacheNomalTransId(String transId, String applyNo);

    /**
     * normal和RA交互时
     * <br/>获取并删除applyNo
     * @param transId 事务ID
     * @return String applyNo 申请编号
     */
    String removeNomalTransId(String transId);

    /**
     * 保存Tbox和RA交互时
     * <br/>Tbox的tboxTransId和applyNo的对应关系
     * @param transId 事务ID
     * @param applyNo 申请编号
     * @return Boolean true 成功；false 失败
     */
    Boolean cacheTboxTransId(String transId, String applyNo);

    /**
     * Tbox和RA交互时
     * <br/>获取并删除applyNo
     * @param transId 事务ID
     * @return String applyNo 申请编号
     */
    String removeTboxTransId(String transId);

    /**
     * 保存RA和CA交互时
     * <br/>RA的applyNo和raTransId的对应关系
     * @param applyNo 申请编号
     * @param tranid 事务ID
     * @return Boolean true 成功；false 失败
     */
    Boolean cacheCaTransId(String applyNo, String tranid);

    /**
     * RA和CA交互时
     * <br/>获取事务ID
     * @param applyNo 申请编号
     * @return String 事务ID
     */
    String getCaTransId(String applyNo);

    /**
     * RA和CA交互时
     * <br/>获取并删除事务ID
     * @param applyNo 申请编号
     * @return String 事务ID
     */
    String removeCaTransId(String applyNo);

    /**
     * 保存RA和SCEP交互时
     * <br/>SCEP的scepTransId和applyNo的对应关系
     * @param transId 事务ID
     * @param applyNo 申请编号
     * @return Boolean true 成功；false 失败
     */
    Boolean cacheScepTransId(String transId, String applyNo);

    /**
     * SCEP和RA交互时
     * <br/>获取applyNo
     * @param transId 事务ID
     * @return String applyNo 申请编号
     */
    String getScepTransId(String transId);

    /**
     * SCEP和RA交互时
     * <br/>获取并删除applyNo
     * @param transId 事务ID
     * @return Boolean true 成功；false 失败
     */
    Long removeScepTransId(String transId);

    /**
     * 保存scep交互时申请编号和公钥信息
     * @param applyNo 申请编号
     * @param publicKeyString 公钥信息 Base64String
     * @return Boolean true 成功；false 失败
     */
    Boolean cacheScepPublicKey(String applyNo, String publicKeyString);

    /**
     * 获取公钥信息
     * @param applyNo 申请编号
     * @return String 公钥信息 Base64String
     */
    String getScepPublicKey(String applyNo);

    /**
     * 获取并删除公钥信息
     * @param applyNo 申请编号
     * @return 是否执行成功：1成功；0失败
     */
    Long removeScepPublicKey(String applyNo);

    /**
     * 保存SDK和RA交互时
     * <br/>SDK的raTransId与baseCMPInfo的对应关系
     * @param sdkTransId 事务ID
     * @param baseCmpInfo CMP请求内容【random/transId等】
     * @return Boolean true 成功；false 失败
     */
    Boolean cacheRaSdkCmpInfo(String sdkTransId, String baseCmpInfo);

    /**
     * 获取并删除缓存信息
     * @param sdkTransId 事务ID
     * @return String CMP请求内容【random/transId等】
     */
    String removeRaSdkCmpInfo(String sdkTransId);

    /**
     * 获取递增的ApplyNo
     * <br/>RA申请证书、证书签发/确认时用到的的申请编号
     * @return string
     */
    String getIncApplyNo();

    /**
     * 获取递增的TransID
     * <br/> RA通过CMP协议与CA交互时的TransID
     * @return string TransID
     */
    String getIncCaCmpTransId();

    /**
     * 获取递增的PairCertIndex
     * <br/> RA保存用户Cert时的PairCertIndex
     * @return string ReqID
     */
    long getIncPairCertIndex();
}
