package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.service.manager.certapply.bean.*;

/**
 * @author: ggp
 * @Date: 2019/10/24 15:30
 * @Description:证书申请管理
 */
public interface CertApplyManagerService {
    /**
     * 获取RA系统的BaseDn
     *
     * @return
     */
    Result getRABaseDn();

    /**
     * 获取用户模板信息
     *
     * @param systemName
     * @return
     */
    Result getTemplateInfoList(String systemName);

    /**
     * 签发申请-发起
     *
     * @param issueApply
     * @return
     */
    Result issueApplyLaunch(IssueApply issueApply, String systemFlag);

    /**
     * 更新申请-发起
     *
     * @param updateApply
     * @param systemFlag
     * @return
     */
    Result updateApplyLaunch(UpdateApply updateApply, String systemFlag);

    /**
     * 撤销申请-发起
     *
     * @param revokeApply
     * @return
     */
    Result revokeApplyLaunch(RevokeApply revokeApply, String systemFlag);

    /**
     * 恢复申请-发起
     *
     * @param revokeApply RecoveryApply
     * @param systemFlag  systemFlag
     * @return ApplyRep类型的签发申请返回对象
     */
    Result recoveryApplyLaunch(RecoveryApply revokeApply, String systemFlag);

    /**
     * 冻结申请-发起
     *
     * @param freezeApply FreezeApply
     * @param systemFlag  systemFlag
     * @return ApplyRep类型的签发申请返回对象
     */
    Result freezeApplyLaunch(FreezeApply freezeApply, String systemFlag);

    /**
     * 申请审核
     *
     * @param applyType
     * @param applyNo
     * @param checkApply
     * @return
     */
    Result applyCheck(Integer applyType, String applyNo, CheckApply checkApply, String systemFlag);

    /**
     * 申请制证执行
     *
     * @param systemFlag
     * @param applyType
     * @param applyNo
     * @param doubleCode
     * @param publickey
     * @return
     */
    Result certApplyCarry(String systemFlag, Integer applyType, String applyNo, DoubleCode doubleCode, byte[] publickey,Integer keyFormat);

    /**
     * 证书签发确认消息
     *
     * @param applyNo
     * @return
     */
    Result certIssueConfirmMsg(String applyNo);

    /**
     * 证书签发错误消息
     *
     * @param applyNo
     * @return
     */
    Result certApplyErrorMsg(String applyNo, ErrorMsg errorMsg);

    /**
     * 查询证书申请信息
     *
     * @param applyType
     * @param applyNo
     * @return
     */
    Result certApplyQuery(Integer applyType, String applyNo, String systemFlag);

    /**
     * 查询证书申请信息
     *
     * @param applyNo
     * @return
     */
    Result certApplyQuery(String applyNo, String systemFlag);

    /**
     * 修改证书申请信息
     *
     * @param applyType
     * @param applyNo
     * @param editCertApplyInfo
     * @return
     */
    Result certApplyUpdate(Integer applyType, String applyNo, EditCertApplyInfo editCertApplyInfo, String systemFlag);

}
