package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.manager.dto.IssueApplyDTO;
import com.xdja.pki.ra.manager.dto.UpdateApplyDTO;

import java.util.Map;

/**
 * 证书申请服务层
 *
 * @author syg
 */
public interface CertApplyService {

    /**
     * 按查询条件，分页查询证书申请信息列表
     *
     * @param userName
     * @param userType
     * @param applyStatus
     * @param pageNo
     * @param pageSize
     * @return
     */
    Result listUserApply(String userCA, String userName, int userType, int applyStatus, int pageNo, int pageSize);


    /**
     * 更新申请信息
     *
     * @param certDn
     * @param applyNo
     * @param applyStatus
     * @return
     */
    Result updateCertApplyInfo(String certDn, String applyNo, int applyStatus,Long tempId);

    /**
     * 添加证书申请记录-SCEP
     * @param applyType
     * @param operateType
     * @param applyNo
     * @param applyStatus
     * @param desc
     * @param operateResultType
     * @return
     */
    Result insertCertApplyRecordScep(int applyType, int operateType, String applyNo, String adminCertDn, int applyStatus, String desc, int operateResultType,boolean isAuto,boolean isOnline);


    /**
     * 添加证书申请记录
     * @param applyType
     * @param operateType
     * @param applyNo
     * @param applyStatus
     * @param desc
     * @param operateResultType
     * @return
     */
    Result insertCertApplyRecord(int applyType, int operateType, String applyNo, String systemFlag, int applyStatus, String desc, int operateResultType,boolean isAuto,boolean isOnline);

    /**
     * 校验证书Dn的合法性
     * @param certDn
     * @param userId
     * @param applyNo
     * @return
     */
    Result verifyUserCertApplyDn(String certDn,long userId ,String applyNo);

    /**
     * 校验证书Dn的合法性
     * @param certDn
     * @return
     */
    Result verifyUserCertApplyDn(String certDn);

    /**
     * 验证是否存在相同sn的证书申请
     * @param signSn
     */
    Result verifyUserCertApply(String signSn,int applyType);

    /**
     * V2X SCEP 签发证书
     *
     * @param systemFlag 系统标识
     * @param issueApplyDTO 签发申请信息
     * @param issueBytes 公钥
     * @param adminCertDn 针对scep系统 证书申请的操作者
     * @return
     */
    Result issueCert(String systemFlag, IssueApplyDTO issueApplyDTO, byte[] issueBytes, String adminCertDn);

    /**
     * V2X更新证书
     * @param updateApplyDTO
     * @param issueBytes
     * @return
     */
    Result updateCert(UpdateApplyDTO updateApplyDTO, byte[] issueBytes);

    /**
     * 用户证书-签发
     *
     * @param certFormatType 签发类型  P10 bks 5  P10 p7b 4
     * @param applyType
     * @param applyNo
     * @param cardNo
     * @param issueBytes     签发公钥信息(针对Tbox方式签发做了兼容，如果是Tbox的申请该内容为公钥，否则为P10信息)
     * @param issueType      签发方式  1 ukey  2 p10
     * @param isOnlineIssue 是否在线签发
     * @param extParam 扩展参数-> [certDn-用户自定义DN && ...]
     * @return
     */
    Result issueUserCert(Integer index,String password,Integer certFormatType, int applyType, String applyNo, String systemFlag, String cardNo
            , byte[] issueBytes, int issueType, boolean isOnlineIssue, boolean isTboxIssue, Map<String, Object> extParam, Integer keyFormat);


    /**
     * 为无密钥生成能力的用户签发用户证书
     * @param certFormatType
     * @param applyNo
     * @param applyType
     * @param isOnlineIssue
     * @return
     */
    Result issueUserCertByKeyStore(int certFormatType, String applyNo, int applyType, boolean isOnlineIssue, Integer keyFormat);

    /**
     * 格式化用户证书  供下载使用
     * @param userCertInfo
     * @return
     */
    Result formatUserCertInfo(String userCertInfo);

    /**
     * 获取申请的详细操作记录
     * @param applyNo
     * @return
     */
    Result listApplyRecord(String applyNo);

    /**
     * 审核证书申请
     * @param applyNo
     * @param applyType
     * @param pass
     * @param checkInfo
     * @return
     */
    Result checkUserCertApply(String applyNo, String systemFlag, int applyType,boolean pass,String checkInfo,boolean isOnlineIssue);


    /**
     * SCEP 签发证书确定请求
     * @param applyNo 申请编号
     * @param adminCertDn 针对scep系统 证书申请的操作者
     * @return
     */
    Result issueUserCertRespScep(String applyNo, String adminCertDn);


    /**
     * 签发证书确定请求
     * @param applyNo
     * @return
     */
    Result issueUserCertResp(String applyNo, String systemFlag, boolean isOnlineIssue);

    /**
     * 根据申请编号获取对应申请下来的签名证书sn
     * @param applyNo
     * @return
     */
    Result getUserCertStatus(String applyNo);

    /**
     * 生成错误CMP消息
     * @param applyNo
     * @param errorCode
     * @param errorMsg
     * @param isOnlineIssue
     * @return
     */
    Result genErrorMsgContent(String applyNo,int errorCode,String errorMsg,boolean isOnlineIssue);

    /**
     * 保存默认容器
     *
     * @param defaultContainer
     * @return
     */
    Result defaultContainer(String defaultContainer);

    /**
     * 获取默认容器
     *
     * @param
     * @return
     */
    Result getDefaultContainer();

    /**
     * 获取模板对应baseDn和系统BaseDn
     * @param tempNo
     * @return
     */
    Result getBaseDn(String tempNo);

    /**
     * 获取系统baseDn
     * @return
     */
    Result getRaBaseDn();

}
