package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.manager.dto.FreezeApplyDTO;

/**
 * 冻结证书申请服务层
 *
 * @author liutao
 */
public interface FreezeApplyService {

    /**
     * 根据申请编号，获取冻结申请
     *
     * @param applyNo
     * @return
     */
    Result getFreezeApplyInfo(String applyNo);

    /**
     * 插入冻结申请记录
     *
     * @param freezeApplyDTO
     * @return
     */
    Result insertUserCertFreezeApply(String systemFlag, FreezeApplyDTO freezeApplyDTO, boolean isOnline, boolean isNormal);

    /**
     * 根据申请编号，更新冻结申请
     *
     * @param applyNo
     * @param freezeApplyDTO
     * @return
     */
    Result updateUserCertFreezeApply(String applyNo, FreezeApplyDTO freezeApplyDTO, boolean isOnlineRevoke);
}
