package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dto.IssueApplyDTO;

/**
 * 签发证书申请服务层
 *
 * @author syg
 */
public interface IssueApplyService {

    /**
     * 根据申请编号，获取签发申请
     * @param applyNo
     * @return
     */
    Result getIssueApplyInfo(String applyNo);

    /**
     * V2X SCEP 签发申请 仅插入certApply issueApply 表
     * @param issueApplyDTO 签发申请信息
     * @param certTempInfo 模板信息
     * @param adminCertDn 针对scep系统 证书申请的操作者
     * @param applyStatus 申请状态
     *
     * @return
     */
    Result insertCertIssueApply(Integer applyStatus, String adminCertDn, IssueApplyDTO issueApplyDTO, CertTempDO certTempInfo);

    /**
     * 插入签发申请记录
     * @param issueApplyDTO
     * @return
     */
    Result insertUserCertIssueApply(String systemFlag, IssueApplyDTO issueApplyDTO,boolean isOnlineIssue,boolean isNormal);

    /**
     * 根据申请编号，更新签发申请
     * @param applyNo
     * @param issueApplyDTO
     * @return
     */
    Result updateUserCertIssueApply(String systemFlag, String applyNo, IssueApplyDTO issueApplyDTO,boolean isIgnoreApplyStatus,boolean isOnlineIssue);

}
