package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.UpdateApplyDTO;

/**
 * 更新证书申请服务层
 *
 * @author syg
 */
public interface UpdateApplyService {

    /**
     * 根据申请编号，获取更新申请
     * @param applyNo
     * @return
     */
    Result getUpdateApplyInfo(String applyNo);

    /**
     * 插入更新申请记录   仅certApply issueApply 表
     * @param updateApplyDTO
     * @return
     */
    Result insertCertUpdateApply(UpdateApplyDTO updateApplyDTO, UserCertDO userCertDO, CertTempDO certTempInfo, boolean isNormal);


    /**
     * 插入更新申请记录
     * @param updateApplyDTO
     * @return
     */
    Result insertUserCertUpdateApply(String systemFlag, UpdateApplyDTO updateApplyDTO, boolean isOnlineUpdate,boolean isNormal);

    /**
     * 根据申请编号，修改更新申请
     * @param applyNo
     * @param updateApplyDTO
     * @return
     */
    Result updateUserCertUpdateApply(String systemFlag, String applyNo,UpdateApplyDTO updateApplyDTO,boolean isOnlineUpdate);
}
