package com.xdja.pki.ra.service.manager.customer;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.service.manager.customer.bean.CustomerCertIssueApplyVO;
import com.xdja.pki.ra.service.manager.customer.bean.CustomerSysVO;
import com.xdja.pki.ra.service.manager.customer.bean.CustomerTemplateSaveVO;

/**
 * @Classname CustomerSysService
 * @Description TODO
 * @Date 2019/10/31 9:55
 * @Author cl
 */
public interface CustomerSysService {

    /**
     * 获取第三方系统证书详情
     * 说明：20201218 原来是调CA查看详情，改为通过RA自己的数据库解析查看详情
     *
     * @param certSn
     * @return
     */
    Result getCustomerCertInfo(String certSn);

    /**
     * 第三方系统注册
     * @param customerSysVO
     * @return
     */
    Result registerCustomerInfo(CustomerSysVO customerSysVO);
    /**
     * 获取客户系统详情
     * @param id
     * @return
     */
    Result getCustomerInfo(Integer id);
    /**
     * 更新客户系统信息
     * @param customerSysVO
     * @return
     */
    Result updateCustomerInfo(Integer id,CustomerSysVO customerSysVO );
    /**
     * 客户系统信息列表
     * @return
     */
    Result getCustomerInfoList(String systemNumber, String systemName,int pageSize,int pageNo);
    /**
     * 客户系统证书列表
     * @return
     */
    Result getCustomerCertInfoList(String systemName, String certDn,String status,String order,int pageSize,int pageNo);

    /**
     * 查询第三方授权模板信息
     * @param id
     * @return
     */
    Result getCustomerTemplateById(Long id);

    /**
     * 保存/更新第三方授权模板信息
     * @param customerTemplateSaveVO
     * @return
     */
    Result saveCustomerTemplates(CustomerTemplateSaveVO customerTemplateSaveVO);
    
    /**
     * 为第三方系统签发证书
     * 说明：20201218 原来是走用户签发，改为走管理员签发
     *
     * @param customerCertIssueApplyVO
     * @return
     */
    Result issCustomerCertByKeyStore(CustomerCertIssueApplyVO customerCertIssueApplyVO);
    /**
     * 为第三方系统签发证书
     * @param
     * @param
     * @return
     */
    Result getCertMaxValidity(String tempNo);

    /**
     * 通过第三方标识 获取第三方证书
     *
     * @param sysNumber
     * @return
     */
    Result getSysCertBySysNumber(String sysNumber,String certSn);

    /**
     * 生成证书确认消息
     * 说明：20201218 原来是走用户确认，改为走管理员确认
     *
     * @param transId
     * @return
     */
     Result genCertConfirm(String transId,String signSn);

    /**
     * 生成错误响应
     * @param transId
     * @param errorCode
     * @param errorMsg
     * @return
     */
     Result genErrorMsgContent(String transId,int errorCode,String errorMsg);

    /**
     * 撤销已有第三方系统设备证书
     * 说明：20201218 原来是走用户撤销，改为走管理员撤销
     *
     * @param signSn
     * @param certDn
     * @param revokeType
     * @param revokeReason
     * @return
     */
    Result revokeCustomerCert(String signSn, String certDn, int revokeType, String revokeReason);

     /**
      * 第三方系统模板下拉选择列表
      * @param customerId
      * @return
      */
     Result getCustomerTemplateSelectList(Long customerId);

    /**
     * 校验客户端证书Dn
     * @param systemFlag
     * @param certDn
     * @return
     */
    Result verifyClientCertDn(String systemFlag,String certDn);

    /**
     * 系统名称唯一性校验
     *
     * @param isUpdate
     * @param id
     * @param systemName
     * @return
     */
    Result verifyCustomerSysName(Boolean isUpdate, Integer id, String systemName);

    /**
     * 系统标识 唯一性校验
     *
     * @param systemNumber
     * @return
     */
    Result verifyCustomerSysNumber(String systemNumber);

    /**
     * 用户注册 系统标识 是否存在校验
     *
     * @param systemNumber
     * @return
     */
    Result verifyUserSystemFlag(String systemNumber);
}
