package com.xdja.pki.ra.service.manager.deviceuser;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceUserInfo;
import com.xdja.pki.ra.service.manager.deviceuser.bean.UserInfo;

import java.util.ArrayList;


/**
 * 设备类信息服务层
 * @author cl
 */
public interface DeviceUserService {
    /**
     * 设备注册
     * @param deviceUserInfo
     * @param userInfo
     * @return
     */
     Result registerDeviceUser(DeviceUserInfo deviceUserInfo, UserInfo userInfo, boolean isV2X);

    /**
     * 设备用户注册
     * @param deviceUserInfo
     * @param userInfo
     * @return
     */
     Result registerBatchDeviceUser(DeviceUserInfo deviceUserInfo, UserInfo userInfo);
    /**
     * 设备批量注册
     * @param
     * @param
     * @return
     */
     Result batchSaveDeviceUserByTemplateFile(ArrayList<ArrayList<String>> lists);

    /**
     * 更新注册信息
     * @return
     */
     Result updateDeviceUser(long deviceId,DeviceUserInfo deviceUserInfo, UserInfo userInfo);

    /**
     * userNo查询设备是否存在
     */
     int getIdByUserNo(String userNo);

    /**
     * 查询设备详情
     *
     */
    Result queryDeviceDetails(long deviceId);

    /**
     *  通过设备类型和设备编号查询设备用户信息
     *
     * @param identType
     * @param licenseNumber
     * @param systemFlag
     * @return
     */
    Result getDevice(Integer identType, String licenseNumber,String systemFlag);
    /**
     * 分页查询已注册设备用户
     *
     */
    Result listDeviceUser(String deviceName,String deviceNo,int status,int pageIndex,int pageSize);



}
