package com.xdja.pki.ra.service.manager.deviceuser.bean;

import org.springframework.stereotype.Repository;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;

@Repository
public class DeviceUserInfo {

    @Size(max = 400)
    private  String deviceDesc;//设备描述

    @Size(min = 1, max = 120)
    private  String userName;//设备名字

    private  String userNo;//设备编号

    @Min(1)
    @Max(6)
    private  Integer licenseType;//设备类型 1:服务器  2:手机  3:网站  4:其他  5:TBox  6:车机

    @Size(min = 1, max = 400)
    private  String licenseNumber;//设备标识符

    private  Integer userType=3;//1:个人用户  2:机构用户  3:设备用户'

    private Integer status=0;//'状态  0:正常  1:已撤销'

    @Size(max = 120)
    private String systemFlag;

    @Size(max = 120)
    private String systemName;

    public String getSystemFlag() {
        return systemFlag;
    }

    public String getSystemName() {
        return systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }
    public void setSystemFlag(String systemFlag) {
        this.systemFlag = systemFlag;
    }

    public String getDeviceDesc() {
        return deviceDesc;
    }

    public void setDeviceDesc(String deviceDesc) {
        this.deviceDesc = deviceDesc;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserNo() {
        return userNo;
    }

    public void setUserNo(String userNo) {
        this.userNo = userNo;
    }

    public Integer getLicenseType() {
        return licenseType;
    }

    public void setLicenseType(Integer licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseNumber() {
        return licenseNumber;
    }

    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
