package com.xdja.pki.ra.service.manager.deviceuser.bean;


import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.manager.dto.UserInfoDTO;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceInfo;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceUserInfo;
import com.xdja.pki.ra.service.manager.deviceuser.bean.UserInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class DeviceUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * 身份证号正则表达式
     */
    //身份证
    private String checkID = "\\d{17}[0-9xX]";
    private String checkPhon = "^(13|14|15|16|17|18|19)[0-9]{9}$";
    private static String checkEmail = "^([a-z0-9A-Z]+[_|-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    private String checkPostCode = "[1-9]\\d{5}";
    private String checkIp = "((25[0-5])|(2[0-4]d)|(1dd)|([1-9]d)|d)(.((25[0-5])|(2[0-4]d)|(1dd)|([1-9]d)|d)){3}";
    private String checkDomain = "[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+.?";
    //护照
    private String checkPassPort = "^[A-Za-z0-9]{9}$";
    //军官证
    private String checkOfficers = "\\d{7}";
    //系统标识  字母加数字15位
    public static final String SYSTEM_FLAG = "^(?=.*[0-9])(?=.*[a-zA-Z])(.{5,15})$";

    /**
     * 校验邮箱，手机号等格式
     */
    public Result checkFormat(ArrayList<String> list) {
        StringBuffer error = new StringBuffer();
        Result result = new Result();
        result.setCode(Constants.FORMAT_DEVICE_USER_SUCESS);
        for (int j = 0; j < list.size(); j++) {
            switch (j) {
                //校验设备名称
                case 0:
                    if (list.get(0).isEmpty()) {
                        logger.info("设备名为空");
                        error = error.append("设备名为空，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    } else if (list.get(0).length() > 30) {
                        logger.info("设备名称格式不正确");
                        error = error.append("设备名称格式不正确，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }
                    break;
                case 1://校验设备类型
                    if (StringUtils.isBlank(list.get(1))) {
                        logger.info("设备类型为空");
                        error = error.append("设备类型为空，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    } else if (!checkDeviceType(list.get(1))) {
                        logger.info("设备类型格式不正确");
                        error = error.append("设备类型格式不正确，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }
                    break;
                case 2://校验设备唯一表示符
                    if (StringUtils.isBlank(list.get(2))) {
                        logger.info("设备唯一标识符空");
                        error = error.append("设备唯一标识符为空,");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }else if (list.get(2).length() > 60) {
                        logger.info("设备唯一标识符格式不正确");
                        error = error.append("设备唯一标识符格式不正确，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }
                    break;
                case 4:
                    if (list.get(4).length() > 30) {
                        logger.info("姓名格式不正确");
                        error = error.append("姓名格式不正确，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }
                    break;
                case 5:
                    if (!checkSex(list.get(5))) {
                        logger.info("性别格式不正确");
                        error = error.append("性别格式不正确，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }
                    break;
                case 6:
                    if (!checkIdType(list.get(6))) {
                        logger.info("证件类型格式不正确");
                        error = error.append("证件类型格式不正确，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }
                    break;
                case 7:
                    if (!checkIdentifier(list.get(6), list.get(7))) {
                        logger.info("证件号码格式不正确");
                        error = error.append("证件号码格式不正确，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }
                    break;
                case 8:
                    if (!isCheck2(list.get(8), checkPhon)) {
                        logger.info("联系电话格式不正确");
                        error = error.append("联系电话格式不正确,");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }
                    break;
                case 9:
                    if (list.get(9).length() > 100) {
                        logger.info("联系地址格式不正确");
                        error = error.append("联系地址格式不正确，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }
                    break;
                case 10:
                   if (!isCheck2(list.get(10), checkEmail) || list.get(10).length() > 30) {
                        logger.info("邮箱格式不正确");
                        error = error.append("邮箱格式不正确，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }
                    break;
                case 11:
                    if (!isCheck2(list.get(11), checkPostCode)) {
                        logger.info("邮编格式不正确");
                        error = error.append("邮箱格式不正确，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }
                    break;
                case 12:
                    if (list.get(12).length() > 100) {
                        logger.error("备注格式不正确");
                        error = error.append("备注格式不正确，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }
                    break;
                case 13:
                    if (list.get(13).length() > 30) {
                        logger.error("所属系统格式不正确");
                        error = error.append("所属系统格式不正确，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }
                    break;
                default:
            }
        }
        if (error.length() > 0) {
            //去掉不正确信息末尾的逗号
            StringBuffer stringBuffer = error.deleteCharAt(error.length() - 1);
            list.add(stringBuffer.toString());
        }
        result.setInfo(list);
        return result;
    }

    public static DeviceInfo format(List<String> list) {
        DeviceInfo deviceInfo = new DeviceInfo();
        DeviceUserInfo deviceUserInfo = new DeviceUserInfo();
        UserInfo userInfo = new UserInfo();
        deviceUserInfo.setUserName(list.get(0));//设备名称
        switch (list.get(1)) {//设备类型
            case "服务器":
                deviceUserInfo.setLicenseType(1);
                break;
            case "手机":
                deviceUserInfo.setLicenseType(2);
                break;
            case "网站":
                deviceUserInfo.setLicenseType(3);
                break;
            case "车机":
                deviceUserInfo.setLicenseType(6);
                break;
            case "T-BOX":
                deviceUserInfo.setLicenseType(5);
                break;
            case "其他":
                deviceUserInfo.setLicenseType(4);
                break;//其它
            default:
        }
        deviceUserInfo.setLicenseNumber(list.get(2));//设备唯一标识
        deviceUserInfo.setDeviceDesc(list.get(3));//设备描述
        userInfo.setPersonName(list.get(4));//用户姓名
        switch (list.get(5)) {//联系人性别
            case "男":
                userInfo.setSex(1);
                break;//1表示男
            case "女":
                userInfo.setSex(2);
                break;//1表示女
            default: userInfo.setSex(0);
        }
        switch (list.get(6)) {//证件类型
            case "身份证":
                userInfo.setLicenseType(Constants.PERSON_LICENSE_TYPE_1);
                break;
            case "军官证":
                userInfo.setLicenseType(Constants.PERSON_LICENSE_TYPE_2);
                break;
            case "护照":
                userInfo.setLicenseType(Constants.PERSON_LICENSE_TYPE_3);
                break;
            case "其他":
                userInfo.setLicenseType(Constants.PERSON_LICENSE_TYPE_4);
                break;
            default:
        }

        userInfo.setLicenseNumber(list.get(7));//证件号码
        userInfo.setTelNumber(list.get(8));//联系电话
        userInfo.setAddress(list.get(9));//联系地址
        userInfo.setEmail(list.get(10));//邮箱
        userInfo.setPostalCode(list.get(11));//邮编
        userInfo.setRemark(list.get(12));//备注
        deviceUserInfo.setSystemName(list.get(13));
        deviceInfo.setDeviceUserInfo(deviceUserInfo);
        deviceInfo.setUserInfo(userInfo);
        return deviceInfo;
    }

    /**
     * 性别格式校验
     *
     * @param sex
     * @return
     */
    public static boolean checkSex(String sex) {
        if (sex.equals(Constants.USER_PERSON_SEX_2) || sex.equals(Constants.USER_PERSON_SEX_1) || StringUtils.isBlank(sex)) {
            return true;
        }
        return false;
    }

    /**
     * 军官证格式校验
     *
     * @param
     * @return
     */
    public boolean checkOfficers(String office) {
        if ("军".equals(office.substring(0, 1)) && office.length() == 8) {
            return isCheck(office.substring(1), checkOfficers);
        }
        return false;
    }

    /**
     * 手机号等格式校验
     *
     * @param
     * @return
     */
    public boolean checkIdentifier(String mobiles, String authen) {
        if(StringUtils.isBlank(authen)){
            return true;
        }
        boolean authenticity = false;
        switch (mobiles) {
            case "网站":
                authenticity = isCheck(authen, checkDomain);
                break;
            case "手机":
                authenticity = isCheck(authen, checkPhon);
                break;
            case "服务器":
                authenticity = isCheck(authen, checkIp);
                break;
            case "身份证":
                authenticity = isCheck(authen, checkID);
                break;
            case "护照":
                authenticity = isCheck(authen, checkPassPort);
                break;
            case "军官证":
                authenticity = checkOfficers(authen);
                break;
            case "其他":
                authenticity = true;
                break;
            default:
        }
        return authenticity;
    }

    /**
     * 设备类型校验
     *
     * @param type
     * @return
     */
    public static boolean checkDeviceType(String type) {
        if ("服务器".equals(type) | "手机".equals(type) | "网站".equals(type) | "其他".equals(type) || "车机".equals(type) || "T-BOX".equals(type)) {
            return true;
        }

        return false;
    }

    /**
     * 证件类型校验
     *
     * @param type
     * @return
     */
    public static boolean checkIdType(String type) {
        if (StringUtils.isBlank(type) || type.equals(Constants.USER_PERSON_LICENSE_TYPE_1) || type.equals(Constants.USER_PERSON_LICENSE_TYPE_2)
                || type.equals(Constants.USER_PERSON_LICENSE_TYPE_3) || type.equals(Constants.USER_PERSON_LICENSE_TYPE_4)) {
            return true;
        }
        return false;
    }

    /**
     * 选填项校验
     *
     * @param pattern
     * @param param
     * @return
     */
    public static boolean isCheck2(String param, String pattern) {
        if (StringUtils.isBlank(param)) {
            return true;
        } else {
            return Pattern.matches(pattern, param);
        }
    }

    /**
     * 正则表达式校验
     *
     * @param mobiles
     * @return
     */
    public static boolean isCheck(String mobiles, String check) {
        boolean matches = Pattern.matches(check, mobiles);
        return matches;
    }
    public static void main(String[] args) {
        boolean ss = isCheck( "it_helpdesk@ai-ways.com", checkEmail);
        System.out.println(ss);
    }
}
