package com.xdja.pki.ra.service.manager.init;

import com.xdja.pki.ra.core.common.Result;


/**
 * 初始化
 *
 * @author wly
 */
public interface InitService {

    /**
     * 判断系统是否初始化
     *
     * @return
     */
    Result isInitialized();

    /**
     * 修改初始化状态操作
     *
     * @return
     */
    Result updateDeviceInitStatus(Integer status);

    /**
     * 修改步骤数
     *
     * @param step
     * @return
     */
    Result updateInitStep(int step);

    /**
     * 获取初始化记录步骤数
     *
     * @return
     */
    Result getOperateStep();

    /**
     * 重新开始初始化操作
     *
     * @return
     */
    Result initDeviceRecover();


    /**
     * 授权业务管理员和审计员
     *
     * @return
     */
    Result authorizeAdmin(String signSn, String cardNo, int adminType);


    /**
     * 初始化系统完成标识
     *
     * @return
     */
    Result initRaSystem();

    /**
     * tomcat重启
     *
     * @return
     */
    Result restartTomcat();


    /**
     * 获取系统算法
     *
     * @return
     */
    Result getSystemKeyAlgName();

    /**
     * 生成对称密钥,仅用于未配置信大捷安密码机前提下
     *
     * @return
     */
    Result genLocalEncryptKey();

    /**
     * 配置数据加密秘钥
     *
     * @param keyIndex 使用信大捷安密码机的对称密钥索引
     * @return
     */
    Result genEncryptKey(Integer keyIndex);

}
