package com.xdja.pki.ra.service.manager.operator;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.manager.dto.AdminCertDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import com.xdja.pki.ra.service.manager.operator.bean.OperatorCertVO;

import java.io.IOException;
import java.util.Map;

/**
 * RA业务操作员证书管理服务层
 *
 * @author syg
 */
public interface OperatorCertService {

    /**
     * 操作员证书信息列表
     * @param certDN
     * @param pageNo
     * @param pageSize
     * @return
     */
    public Result queryOperatorCertList(String certDN, int pageNo, int pageSize);


    /**
     * 根据证书sn获取证书详细信息
     *
     * @param certSn
     * @param certType
     * @return
     */
    public Result getOperatorCertDetail(String certSn, int certType);

    /**
     * 根据证书sn获取证书基本信息
     *
     * @param certSn
     * @return
     */
    public Result getOperatorCertInfo(String certSn);

    /**
     * 根据签名证书sn获取双证书数据信息
     *
     * @param signSn
     * @return
     */
    public Result getOperatorCertBase64Info(String signSn);

    /**
     * 获取RA的管理员证书模板信息
     * @return
     */
    public Result getRaOperatorCertTemp() throws IOException;

    /**
     * 获取RA业务管理员证书最大有效期
     * @param signSn
     * @return
     */
    public Result getOperatorCertMaxValidity(int updateKey,String signSn);


    /**
     * 添加操作员员证书信息
     *
     * @param adminCertDTO
     * @return
     */
    public Result insertOperatorCert(AdminCertDTO adminCertDTO);


    /**
     * 更新操作员基本信息
     *
     * @param adminCertDTO
     * @return
     */
    public Result updateOperatorCert(AdminCertDTO adminCertDTO);


    /**
     * 撤销操作员证书
     * @param signSn
     * @param certDn
     * @param revokeType
     * @param revokeReason
     * @return
     */
    public Result revokeOperatorCert(String signSn,String certDn,int revokeType,String revokeReason);

    /**
     * 更新管理员证书状态
     * @param certStatus
     * @param certSn
     * @return
     */
    public Result updateOperatorCertStatus(int certStatus,String certSn);


    /**
     * 生成证书确认消息
     * @param transId
     * @param encSn
     * @param encCert
     * @return
     */
    public Result genCertConfirm(String transId, String signSn, String encSn, String encCert);


    /**
     * 校验操作员申请的证书DN
     * @param certDn
     * @return
     */
    public Result verifyOperatorCertApplyDn(String certDn);

    /**
     * 生成错误响应
     * @param transId
     * @param errorCode
     * @param errorMsg
     * @return
     */
    public Result genErrorMsgContent(String transId,int errorCode,String errorMsg);
}
