package com.xdja.pki.ra.service.manager.organuser;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.manager.dto.OrganUserInfoDTO;
import com.xdja.pki.ra.manager.dto.UserInfoDTO;

import java.util.ArrayList;

/**
 * @author wly
 */
public interface OrganUserService {
    /**
     * 按查询条件，分页查询机构用户信息列表
     *
     * @param organName
     * @param licenseNumber
     * @param status
     * @param pageNo
     * @param pageSize
     * @return
     */
    Result listOrganUser(String organName, String licenseNumber, Integer status, Integer pageNo, Integer pageSize);

    /**
     * 注册机构用户
     *
     * @param userInfoDTO
     * @param organUserInfoDTO
     * @return
     */
    Result saveOrganUser(UserInfoDTO userInfoDTO, OrganUserInfoDTO organUserInfoDTO);


    /**
     * 根据机构用户Id，获取用户详情
     *
     * @param organId
     * @return
     */
    Result getOrganUserInfo(Long organId);


    /**
     * 根据机构类型和设备编号查询机构用户信息
     *
     * @param identType
     * @param licenseNumber
     * @param systemFlag
     * @return
     */
    Result getOrganUser(Integer identType, String licenseNumber,String systemFlag);

    /**
     * 根据id，更新机构用户信息
     *
     * @param organId
     * @param updateOrganUserInfoDTO
     * @param updateUserInfoDTO
     * @return
     */
    Result updateOrganUserInfo(Long organId, OrganUserInfoDTO updateOrganUserInfoDTO, UserInfoDTO updateUserInfoDTO);

    /**
     * 批量注册
     *
     * @param fileList
     * @return
     */
    Result batchSaveOrganUserByTemplateFile(ArrayList<ArrayList<String>> fileList);

    /**
     * 批量注册-注册接口
     *
     * @param userInfoDTO
     * @param organUserInfoDTO
     * @return
     */
    Result batchSaveOrganUser(UserInfoDTO userInfoDTO, OrganUserInfoDTO organUserInfoDTO);


}
