package com.xdja.pki.ra.service.manager.organuser.bean;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.constant.Constants;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.regex.Pattern;

/**
 * 参数校验
 *
 * @author wly
 */
public class OrganParamsCheck {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    //身份证
    private static final String ID_NUMBER_PATTERN = "\\d{17}[0-9xX]";
    //军官证 军+7位数字
    private static final String JUNGUAN_NUMBER_PATTERN = "\\d{7}";
    //护照  字母加数字9位
    public static final String PASSPORT_NUMBER_PATTERN = "^[A-Za-z0-9]{9}$";
    //邮箱
    public static final String EMAIL_NUMBER_PATTERN = "^([a-z0-9A-Z]+[_|-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    //邮编
    public static final String POSTALCODE_NUMBER_PATTERN = "[1-9]\\d{5}";
    //手机号
    public static final String TELNUMBER_NUMBER_PATTERN = "^(13|14|15|16|17|18|19)[0-9]{9}$";
    //企业licenseNumber
    public static final String ORGAN_NUMBER_PATTERN = "^.{1,30}$";
    //系统标识  字母加数字15位
    public static final String SYSTEM_FLAG = "^(?=.*[0-9])(?=.*[a-zA-Z])(.{5,15})$";


    public Result checkOrganParams(ArrayList<String> list) {

        Result result = new Result();
        result.setCode(Constants.ANALYSIS_EXCEL_0);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); i++) {
            switch (i) {
                case 0:
                    //校验机构名称
                    if (list.get(0) == null || list.get(0).isEmpty()) {
                        logger.error("机构名称不能为空");
                        stringBuffer = stringBuffer.append("机构名称不能为空，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    } else if (list.get(0).length() > 30) {
                        logger.error("机构名称格式不正确");
                        stringBuffer = stringBuffer.append("机构名称格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 1://校验法人代表 do可以为空 0326
                    if (list.get(1).length() > 30) {
                        logger.error("机构法人代表格式不正确");
                        stringBuffer = stringBuffer.append("机构法人代表格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 2://校验证件类型
                    if (list.get(2) == null || list.get(2).isEmpty()) {
                        logger.error("机构证件类型不能为空");
                        stringBuffer = stringBuffer.append("机构证件类型不能为空，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    } else if (!list.get(2).equals(Constants.ORGAN_LICENSE_TYPE_1) && !list.get(2).equals(Constants.ORGAN_LICENSE_TYPE_2) && !list.get(2).equals(Constants.ORGAN_LICENSE_TYPE_3) && !list.get(2).equals(Constants.ORGAN_LICENSE_TYPE_4)) {
                        logger.error("机构证件类型格式不正确");
                        stringBuffer = stringBuffer.append("机构证件类型格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 3://校验证件号码
                    if (list.get(3) == null || list.get(3).isEmpty()) {
                        logger.error("机构证件号码不能为空");
                        stringBuffer = stringBuffer.append("机构证件号码不能为空，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    } else if (!isCheck(ORGAN_NUMBER_PATTERN, list.get(3))) {
                        logger.error("机构证件号码格式不正确");
                        stringBuffer = stringBuffer.append("机构证件号码格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 4:
                    //地址 do可以为空 0326
                    if (list.get(4).length() > 100) {
                        logger.error("机构联系地址格式不正确");
                        stringBuffer = stringBuffer.append("机构联系地址格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 5:
                    //邮箱 do可以为空 0326
                    if (!isCheck2(EMAIL_NUMBER_PATTERN, list.get(5)) || list.get(5).length() > 30) {
                        logger.error("机构邮箱格式不正确");
                        stringBuffer = stringBuffer.append("机构邮箱格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 6:
                    if (!isCheck2(POSTALCODE_NUMBER_PATTERN, list.get(6))) {
                        logger.error("机构邮编格式不正确");
                        stringBuffer = stringBuffer.append("机构邮编格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 7:
                    //联系人姓名 do可以为空 0326
                    if (list.get(7).length() > 30) {
                        logger.error("联系人姓名格式不正确");
                        stringBuffer = stringBuffer.append("联系人姓名格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 8:
                    //联系人姓名 do可以为空 0326
                    if (!checkSex(list.get(8))) {
                        logger.error("联系人性别格式不正确");
                        stringBuffer = stringBuffer.append("联系人性别格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 9://校验证件类型 do可以为空 0326
                    if (StringUtils.isNotBlank(list.get(9)) && !list.get(9).equals(Constants.USER_PERSON_LICENSE_TYPE_1) && !list.get(9).equals(Constants.USER_PERSON_LICENSE_TYPE_2) && !list.get(9).equals(Constants.USER_PERSON_LICENSE_TYPE_3) && !list.get(9).equals(Constants.USER_PERSON_LICENSE_TYPE_4)) {
                        logger.error("联系人证件类型格式不正确");
                        stringBuffer = stringBuffer.append("联系人证件类型格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 10:
                    if (!checkLicenseNumber(list.get(9), list.get(10))) {
                        logger.error("联系人证件号码格式不正确");
                        stringBuffer = stringBuffer.append("联系人证件号码格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 11:
                    if (!isCheck2(TELNUMBER_NUMBER_PATTERN, list.get(11))) {
                        logger.error("联系人联系电话格式不正确");
                        stringBuffer = stringBuffer.append("联系人联系电话格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 12:
                    if (list.get(12).length() > 100) {
                        logger.error("联系人联系地址格式不正确");
                        stringBuffer = stringBuffer.append("联系人联系地址格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 13: // do可以为空 0326
                    if (!isCheck2(EMAIL_NUMBER_PATTERN, list.get(13)) || list.get(13).length() > 30) {
                        logger.error("联系人邮箱格式不正确");
                        stringBuffer = stringBuffer.append("联系人邮箱格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 14:
                    if (!isCheck2(POSTALCODE_NUMBER_PATTERN, list.get(14))) {
                        logger.error("联系人邮编格式不正确");
                        stringBuffer = stringBuffer.append("联系人邮编格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 15:
                    if (list.get(15).length() > 100) {
                        logger.error("联系人备注格式不正确");
                        stringBuffer = stringBuffer.append("联系人备注格式不正确，");
                        result.setCode(Constants.ANALYSIS_EXCEL_1);
                    }
                    break;
                case 16:
                    if (list.get(16).length() > 30) {
                        logger.error("所属系统格式不正确");
                        stringBuffer = stringBuffer.append("所属系统格式不正确，");
                        result.setCode(Constants.FORMAT_DEVICE_USER_FAIL);
                    }
                    break;
                default:
            }
        }

        if (stringBuffer.length() > 0) {
            String substring = stringBuffer.substring(0, stringBuffer.length() - 1);
            list.add(substring);
        }
        result.setInfo(list);

        return result;
    }

    /**
     * 必填项校验
     *
     * @param pattern
     * @param param
     * @return
     */
    public static boolean isCheck(String pattern, String param) {
        boolean matches = Pattern.matches(pattern, param);
        return matches;
    }

    /**
     * 选填项校验
     *
     * @param pattern
     * @param param
     * @return
     */
    public static boolean isCheck2(String pattern, String param) {
        if (StringUtils.isBlank(param)) {
            return true;
        } else {
            return Pattern.matches(pattern, param);
        }
    }

    /**
     * 性别格式校验
     *
     * @param sex
     * @return
     */
    public static boolean checkSex(String sex) {
        if (StringUtils.isBlank(sex)|| sex.equals(Constants.USER_PERSON_SEX_2) | sex.equals(Constants.USER_PERSON_SEX_1)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 联系人licenseNumber分类校验
     *
     * @param licenseType
     * @param licenseNumber
     * @return
     */
    public Boolean checkLicenseNumber(String licenseType, String licenseNumber) {

        if (licenseType.equals(Constants.USER_PERSON_LICENSE_TYPE_1)) {
            return isCheck(ID_NUMBER_PATTERN, licenseNumber);
        } else if (licenseType.equals(Constants.USER_PERSON_LICENSE_TYPE_2)) {
            if ("军".equals(licenseNumber.substring(0, 1)) && licenseNumber.length() == 8) {
                return isCheck(JUNGUAN_NUMBER_PATTERN, licenseNumber.substring(1));
            } else {
                return false;
            }
        } else if (licenseType.equals(Constants.USER_PERSON_LICENSE_TYPE_3)) {
            return isCheck(PASSPORT_NUMBER_PATTERN, licenseNumber);
        } else if (licenseType.equals(Constants.USER_PERSON_LICENSE_TYPE_4)) {
            //logger.info("证件类型其他");
            return true;
        } else {
            //填写为空或非指定项  do可以为空 0326
            return true;
        }
    }
}
