package com.xdja.pki.ra.service.manager.organuser.bean;

import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.manager.dto.OrganUserInfoDTO;
import com.xdja.pki.ra.manager.dto.UserInfoDTO;

import java.util.List;

/**
 * list 转 DTO
 *
 * @author wly
 */
public class ToOrganUserVO {
    public static SaveOrganUserVO format(List<String> list) {
        SaveOrganUserVO saveOrganUserVO = new SaveOrganUserVO();
        OrganUserInfoDTO organUserInfoDTO = new OrganUserInfoDTO();
        UserInfoDTO userInfoDTO = new UserInfoDTO();
        organUserInfoDTO.setOrganName(list.get(0));
        organUserInfoDTO.setLegalPerson(list.get(1));
        switch (list.get(2)) {
            case "企业工商注册号":
                organUserInfoDTO.setLicenseType(Constants.LICENSE_TYPE_1);
                break;
            case "企业组织机构代码":
                organUserInfoDTO.setLicenseType(Constants.LICENSE_TYPE_2);
                break;
            case "企业税号":
                organUserInfoDTO.setLicenseType(Constants.LICENSE_TYPE_3);
                break;
            case "其他":
                organUserInfoDTO.setLicenseType(Constants.LICENSE_TYPE_4);
                break;
            default:
                organUserInfoDTO.setLicenseType(Constants.LICENSE_TYPE_5);
        }
        organUserInfoDTO.setLicenseNumber(list.get(3));
        organUserInfoDTO.setAddress(list.get(4));
        organUserInfoDTO.setEmail(list.get(5));
        organUserInfoDTO.setPostalCode(list.get(6));
        userInfoDTO.setPersonName(list.get(7));
        switch (list.get(8)) {
            case "男":
                userInfoDTO.setSex(Constants.PERSON_SEX_1);
                break;
            case "女":
                userInfoDTO.setSex(Constants.PERSON_SEX_2);
                break;
            default:
                userInfoDTO.setSex(Constants.PERSON_SEX_0);
        }
        switch (list.get(9)) {
            case "身份证":
                userInfoDTO.setLicenseType(Constants.PERSON_LICENSE_TYPE_1);
                break;
            case "军官证":
                userInfoDTO.setLicenseType(Constants.PERSON_LICENSE_TYPE_2);
                break;
            case "护照":
                userInfoDTO.setLicenseType(Constants.PERSON_LICENSE_TYPE_3);
                break;
            case "其他":
                userInfoDTO.setLicenseType(Constants.PERSON_LICENSE_TYPE_4);
                break;
            default:
        }
        userInfoDTO.setLicenseNumber(list.get(10));
        userInfoDTO.setTelNumber(list.get(11));
        userInfoDTO.setAddress(list.get(12));
        userInfoDTO.setEmail(list.get(13));
        userInfoDTO.setPostalCode(list.get(14));
        userInfoDTO.setRemark(list.get(15));
        organUserInfoDTO.setSystemName(list.get(16));
        saveOrganUserVO.setUserInfoDTO(userInfoDTO);
        saveOrganUserVO.setOrganUserInfoDTO(organUserInfoDTO);
        return saveOrganUserVO;
    }
}
