package com.xdja.pki.ra.service.manager.personuser;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.manager.dto.PersonUserDTO;
import com.xdja.pki.ra.service.manager.personuser.bean.PersonUserInfo;

import java.util.ArrayList;

/**
 * 个人用户服务层
 *
 * @author syg
 */
public interface PersonUserService {

    /**
     * 按查询条件，分页查询个人用户信息列表
     *
     * @param personName
     * @param licenseNumber
     * @param status
     * @param pageNo
     * @param pageSize
     * @return
     */
    Result listPersonUser(String personName, String licenseNumber, int status, int pageNo, int pageSize);

    /**
     * 按ID查询个人用户详情
     *
     * @param personId
     * @return
     */
    Result getPersonUserDetails(long personId);

    /**
     * 通过证件类型和证件号码查询个人用户详情
     * @param identType
     * @param licenseNumber
     * @return
     */
    Result getPersonUserDetailsByLicenseTypeAndLicenseNumber(Integer identType, String licenseNumber,String systemFlag);

    /**
     * 修改个人用户信息
     *
     * @param personId
     * @param personUserInfo
     * @return
     */
    Result updatePersonUser(int personId, PersonUserInfo personUserInfo);

    /**
     * 注册用户
     *
     * @param personUserInfo
     * @return
     */
    Result savePersonUser(PersonUserDTO personUserInfo);

    /**
     * 注册个人用户 -- 批量注册调用
     *
     * @param personUserInfo
     * @return
     */
    Result saveBatchPersonUser(PersonUserDTO personUserInfo);

    /**
     * 批量注册
     *
     * @param fileList
     * @return
     */
    Result batchSavePersonUserByTemplateFile(ArrayList<ArrayList<String>> fileList);


}
