package com.xdja.pki.ra.service.manager.personuser.bean;

import org.springframework.stereotype.Repository;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;

@Repository
public class PersonUserInfo {
    @Min(1)
    @Max(3)
    private Integer  userType=1;//用户类型  1:个人用户  2:机构用户  3:设备用户
    @Max(2)
    private Integer  sex;//性别 0男，1女
    @Size(min = 1, max = 120)
    private String personName;//用户名
    @Min(1)
    @Max(5)
    private Integer licenseType;//证件类型  1:身份证  2:军官证  3:驾驶证  4:护照  5:其它
    @Size(min = 1, max = 120)
    private String licenseNumber;//证件号码
    @Size(max = 400)
    private String address;//联系地址
    @Size(max = 120)
    private String email;
    @Size(max = 20)
    private String postalCode;
    @Size(max = 20)
    private String telNumber;//电话
    @Size(max = 400)
    private String companyName;//单位名称
    @Size(max = 400)
    private String companyAddress;//单位地址
    @Size(max = 400)
    private String remark;//备注
    @Size(max = 120)
    private String systemFlag;

    public String getSystemFlag() {
        return systemFlag;
    }

    public void setSystemFlag(String systemFlag) {
        this.systemFlag = systemFlag;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }


    public String getPersonName() {
        return personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public Integer getLicenseType() {
        return licenseType;
    }

    public void setLicenseType(Integer licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseNumber() {
        return licenseNumber;
    }

    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getTelNumber() {
        return telNumber;
    }

    public void setTelNumber(String telNumber) {
        this.telNumber = telNumber;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCompanyAddress() {
        return companyAddress;
    }

    public void setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

}
