package com.xdja.pki.ra.service.manager.scep;

import com.xdja.pki.ra.core.common.Result;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

/**
 * scep证书接口类
 *
 * @author wly
 */
public interface ScepCertService {

    /**
     * 注册签发
     *
     * @param pkcs10CertificationRequest     p10
     * @param transactionId 事务控制id
     * @return 待审核-null 签发成功-cert : UserCertInfo userCertInfo
     */
    Result issueScepCert(PKCS10CertificationRequest pkcs10CertificationRequest, String transactionId) throws Exception;

    /**
     * 获取RA服务器证书签名证书链
     *
     * @return String:signCert.p7b or String encCert.cer
     */
    Result getRaCert(int type);

    /**
     * 查询注册证书
     *
     * @param sn       证书sn
     * @param issuerDn 证书颁发者
     * @return Map<String, String> signCert encCert
     */
    Result getScepCert(String sn, String issuerDn);

    /**
     * 轮循查询证书
     *
     * @param transactionId 事务id
     * @param subjectDn     证书主体
     * @param issuerDn      颁发者主体
     * @return 待审核-null 签发成功-cert:Map<String, String> signCert encCert
     */
    Result pollScepCert(String transactionId, String subjectDn, String issuerDn);

}
