package com.xdja.pki.ra.service.manager.scep;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.service.manager.scep.bean.ScepDeviceVO;

import java.util.HashSet;

/**
 * scep设备管理接口类
 *
 * @author wly
 */
public interface ScepDeviceService {

    /**
     * scep设备注册
     *
     * @param scepDeviceVO 注册信息
     * @return
     */
    Result registerScepInfo(ScepDeviceVO scepDeviceVO);

    /**
     * scep设备详情
     *
     * @param id 主键id
     * @return
     */
    Result getScepInfo(Long id);

    /**
     * 校验scep设备名称唯一性
     *
     * @param scepName 设备名称
     * @return
     */
    Result verifyScepDeviceName(String scepName);

    /**
     * SCEP设备列表
     *
     * @param scepName      设备名称
     * @param scepChallenge 授权码
     * @param pageSize      每页个数
     * @param pageNo        页码
     * @return
     */
    Result getScepDeviceList(String scepName, String scepChallenge, Integer pageSize, Integer pageNo);

    /**
     * 通过id获取SCEP授权模板
     *
     * @param id 主键id
     * @return
     */
    Result getScepTemplateById(Long id);

    /**
     * 获取SCEP内置授权模板
     *
     * @return
     */
    Result getScepTemplateInner();

    /**
     * 获取授权模板 被调用类
     *
     * @param tempNo 模板编号
     * @return
     */
    Result getScepTemplateByTemp(String tempNo);

    /**
     * 保存scep授权模板
     *
     * @param id     主键id
     * @param tempNo 模板编号
     * @return
     */
    Result saveScepTemplate(Long id, String tempNo);

    /**
     * 保存scep默认模板编号
     *
     * @param tempNo 模板编号
     * @return
     */
    Result saveScepInnerTemplate(String tempNo);

    /**
     * 更新所有SCEP设备已停用模板编号为空 未使用
     *
     * @return
     */
    Result updateScepDeviceTempNo(HashSet tempNoHashSet);

}
