package com.xdja.pki.ra.service.manager.statistics;

import com.xdja.pki.ra.service.manager.statistics.bean.CertTemplateVO;
import com.xdja.pki.ra.service.manager.statistics.bean.StatisticsCertVO;
import com.xdja.pki.ra.service.manager.statistics.bean.StatisticsCustomerVO;
import com.xdja.pki.ra.service.manager.statistics.bean.StatisticsUserVO;

import java.util.List;

public interface StatisticsService {

    /**
     * 第三方系统证书拥有数统计 条件查询
     *
     * @param customerSysName 系统名称
     * @param startTime       开始时间
     * @param endTime         结束时间
     * @return
     */
    List<StatisticsCustomerVO> getCustomerCertStatistics(String customerSysName, String startTime, String endTime);


    /**
     * 根据条件进行证书数量统计
     *
     * @param certTemplateName 模板ID 过滤项
     * @param startTime      开始时间 过滤项
     * @param endTime        结束时间 过滤项
     * @return 列表对象
     */
    List<StatisticsCertVO> getCertStatistics(String certTemplateName, String startTime, String endTime);

    /**
     * 根据条件进行用户数量统计
     *
     * @param startTime 开始时间 过滤项
     * @param endTime   结束时间 过滤项
     * @return 列表对象
     */
    List<StatisticsUserVO> getUserStatistics(String startTime, String endTime);

    List<CertTemplateVO> getCertTemplate();
}
