package com.xdja.pki.ra.service.manager.statistics.bean;

import com.xdja.pki.ra.core.util.file.ExcelCell;

/**
 * 第三方系统证书拥有统计
 *
 * @author wly
 */
public class StatisticsCustomerVO {

    @ExcelCell(title = "系统名称", width = 30, isDate = false)
    private String customerSysName;

    @ExcelCell(title = "系统标识", width = 30, isDate = false)
    private String customerSysNumber;

    @ExcelCell(title = "正常", width = 10, isDate = false)
    private int normal = 0;

    @ExcelCell(title = "已撤销", width = 10, isDate = false)
    private int revoke = 0;

    @ExcelCell(title = "已过期", width = 10, isDate = false)
    private int expire = 0;

    @ExcelCell(title = "已冻结", width = 10, isDate = false)
    private int freeze = 0;

    @ExcelCell(title = "合计", width = 10, isDate = false)
    private int total = 0;

    public String getCustomerSysNumber() {
        return customerSysNumber;
    }

    public void setCustomerSysNumber(String customerSysNumber) {
        this.customerSysNumber = customerSysNumber;
    }

    public String getCustomerSysName() {
        return customerSysName;
    }

    public void setCustomerSysName(String customerSysName) {
        this.customerSysName = customerSysName;
    }

    public int getNormal() {
        return normal;
    }

    public void setNormal(int normal) {
        this.normal = normal;
    }

    public int getRevoke() {
        return revoke;
    }

    public void setRevoke(int revoke) {
        this.revoke = revoke;
    }

    public int getExpire() {
        return expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public int getTotal() {
        return total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getFreeze() {
        return freeze;
    }

    public void setFreeze(int freeze) {
        this.freeze = freeze;
    }

    @Override
    public String toString() {
        return "StatisticsCustomerVO{" +
                "customerSysNumber='" + customerSysNumber + '\'' +
                ", customerSysName='" + customerSysName + '\'' +
                ", normal=" + normal +
                ", revoke=" + revoke +
                ", expire=" + expire +
                ", freeze=" + freeze +
                ", total=" + total +
                '}';
    }
}
