package com.xdja.pki.ra.service.manager.system;


import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.manager.dao.model.CaCertDO;
import org.springframework.web.multipart.MultipartFile;

/**
 * CA服务配置
 *
 * @author wly
 */
public interface CaService {

    /**
     * 配置CA服务--初始化
     *
     * @param file         证书链文件
     * @param caServerIp
     * @param caServerPort
     * @return
     */
    Result configCaServer(MultipartFile file, String caServerIp, int caServerPort);

    /**
     * 更新CA服务 仅更新IP和端口
     * @param caServerIp
     * @param caServerPort
     * @return
     */
    Result updateLessCAServer( String caServerIp, int caServerPort);

    /**
     * 更新CA服务
     *
     * @param file         证书链文件
     * @param caServerIp
     * @param caServerPort
     * @return
     */
    Result updateConfigCaServer(MultipartFile file, String caServerIp, int caServerPort);

    /**
     * CA服务配置详情 仅config.json配置文件CA信息
     *
     * @return
     */
    Result getCaConfigInfo();


    /**
     * CA服务配置详情 数据库 ---同 获取最新的CA证书
     *
     * @return
     */
    CaCertDO getCaConfigInfoByTime();

    /**
     * 获取最新的CA证书
     * @return
     */
    Result getNewCaCertInfo();

    /**
     * 获取系统CA服务器证书DN
     * @return
     */

    String getCAServiceDnName();

    /**
     * 导入证书链获取信息
     *
     * @param file
     * @param isUpdate
     * @return
     */
    Result getVerifyCaCertInfo(MultipartFile file ,boolean isUpdate);
}
