package com.xdja.pki.ra.service.manager.system;

import com.xdja.pki.ra.core.common.Result;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;

public interface HsmServer {
    /**
     * 密码机保存IP，端口，证书  XDJA
     * @param hsmServerIp
     * @param hsmServerPort
     * @param signCertPwd
     * @param encCertPwd
     * @param sign
     * @param enc
     * @param certChain
     * @return
     */
    Result initHsmServer(String hsmServerIp, int hsmServerPort, String signCertPwd,String encCertPwd,MultipartFile sign,MultipartFile enc, MultipartFile certChain);
    /**
     * 测试密码机连接  XDJA
     * @return
     */
    Result testHsmConnect(String hsmServerIp, int hsmServerPort, String signCertPwd, String encCertPwd, MultipartFile sign, MultipartFile enc, MultipartFile certChain);
    /**
     * 系统管理中检查密码机系统服务的状态   XDJA
     * @return
     */
    Result testHsmConnect();

    /**
     * 初始化不配置密码机
     *
     * @return
     */
    Result isHsm();

    /**
     * 保存三未信安密码机配置
     *
     * @param hsmServerIp
     * @param hsmServerPort
     * @param accessPassword
     * @return
     */
    Result saveSwxaHsm(String hsmServerIp, int hsmServerPort, String accessPassword, boolean isInit);

    /**
     * 三未信安密码机测试连接
     *
     * @param hsmServerIp
     * @param hsmServerPort
     * @param accessPassword
     * @return
     */
      Result testSwxaHsmConnect(String hsmServerIp, int hsmServerPort, String accessPassword, boolean isInit);

    /**
     * 系统配置密码机详情展示---兼容SWXA和XDJA
     *
     * @return
     */
    Result getHsmInfo();

}
