package com.xdja.pki.ra.service.manager.system;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.manager.dao.model.RaCertDO;
import org.springframework.web.multipart.MultipartFile;

import java.security.cert.X509Certificate;

/**
 * RA服务
 * @author cl
 */
public interface RaServer {


    /**
     * 修改RAServer配置
     * @param keyIndex
     * @param priKeyPwd
     * @param certChain
     * @param enc
     * @param enc
     * @param certChain
     * @return
     */
    Result updateRaServerConfig(Integer keyIndex, String priKeyPwd, MultipartFile certChain, MultipartFile enc);

    /**
     * 初始化RAServer配置
     * @param certChain
     * @param enc
     * @param enc
     * @param certChain
     * @return
     */
    Result initRaServerConfig(Integer keyIndex, String priKeyPwd, MultipartFile certChain, MultipartFile enc);

    /**
     * 获取RA服务器证书详情
     * @return type 1 签名证书，2 加密证书
     */
    Result getRaServerCertDetails(int type);

    /**
     * 获取RA服务器配置详情
     * @return
     */
    Result getRaServerConfigInfo();

    /**
     * 获取RA服务器最新的签名证书
     * @param
     * @return
     */
    Result getRaServerCertInfo();

    /**
     * 判断系统是否使用硬件设备 并返回秘钥长度 秘钥算法
     *
     * @return
     */
    Result isUseHsmInfo();

    /**
     * 生成RA服务器证书申请书P10
     * @param certDn
     * @param keyLength
     * @param keyAlg
     * @return
     */
    Result genRaServerCertP10(String certDn,int keyLength, String keyAlg, boolean isInit) throws Exception;

    /**
     * 下载RA服务器证书申请文件
     */
    Result downloadRaServerCertReq(String zipFileName);

    /**
     * 获取系统RA服务器签名证书DN
     * @return
     */
    String getRAServiceDnName();

}


