package com.xdja.pki.ra.service.manager.system.bean;

import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @ClassName: ArchiveConfigVO class
 * @Description: TODO
 * @Author: songxuetao
 * @Version: v1.0.0
 **/
public class ArchiveConfigVO implements Serializable {

    private static final long serialVersionUID = 1L;

    //最多存储操作日志条数
    @Min(10000)
    @Max(1000000)
    private Integer maxAuditLogLimit;

    //周期审计日志周期；以小时为单位
    @Min(1)
    @Max(48)
    private Integer auditLogPeriod;

    //自动归档开关，1开启，0关闭
    @Min(0)
    @Max(1)
    private Integer autoArchiveFlag;

    //每月的几号进行自动归档
    @Min(0)
    @Max(28)
    private Integer autoArchivePeriod;

    //归档多少天前的日志
    @Min(0)
    @Max(2000)
    private Integer autoArchiveAgo;

    public Integer getMaxAuditLogLimit() {
        return maxAuditLogLimit;
    }

    public void setMaxAuditLogLimit(Integer maxAuditLogLimit) {
        this.maxAuditLogLimit = maxAuditLogLimit;
    }

    public Integer getAuditLogPeriod() {
        return auditLogPeriod;
    }

    public void setAuditLogPeriod(Integer auditLogPeriod) {
        this.auditLogPeriod = auditLogPeriod;
    }

    public Integer getAutoArchiveFlag() {
        return autoArchiveFlag;
    }

    public void setAutoArchiveFlag(Integer autoArchiveFlag) {
        this.autoArchiveFlag = autoArchiveFlag;
    }

    public Integer getAutoArchivePeriod() {
        return autoArchivePeriod;
    }

    public void setAutoArchivePeriod(Integer autoArchivePeriod) {
        this.autoArchivePeriod = autoArchivePeriod;
    }

    public Integer getAutoArchiveAgo() {
        return autoArchiveAgo;
    }

    public void setAutoArchiveAgo(Integer autoArchiveAgo) {
        this.autoArchiveAgo = autoArchiveAgo;
    }

    private String autoArchiveFlagTrans(Integer autoArchiveFlag){
        if (autoArchiveFlag.intValue() == 1){
            return "自动归档开启";
        } else if (autoArchiveFlag.intValue() == 0){
            return "自动归档关闭";
        } else {
            return null;
        }
    }

    @Override
    public String toString() {
        return "ArchiveConfigVO{" +
                "maxAuditLogLimit=" + maxAuditLogLimit +
                ", auditLogPeriod=" + auditLogPeriod +
                ", autoArchiveFlag=" + autoArchiveFlag +
                ", autoArchivePeriod=" + autoArchivePeriod +
                ", autoArchiveAgo=" + autoArchiveAgo +
                '}';
    }

    public String toCNString() {
        StringBuffer sb = new StringBuffer();
        sb.append("最多存储").append(maxAuditLogLimit).append("条操作日志, 审计日志周期").append(auditLogPeriod).append("小时, ").append(autoArchiveFlagTrans(autoArchiveFlag));
        if((autoArchiveFlag.intValue() == 1)) {
            sb.append(", 每月").append(autoArchivePeriod).append("号进行自动归档, 归档").append(autoArchiveAgo).append("天前的日志");
        }
        return sb.toString();
    }
}
