package com.xdja.pki.ra.service.manager.tbox;

import com.xdja.pki.ra.core.common.Result;

/**
 * tbox设备服务
 *
 * @author syg
 */
public interface TboxDeviceService {

    /**
     * 注册Tbox设备
     *
     * @param deviceNo
     * @param deviceType
     * @param deviceName
     * @param deviceDesc
     * @return
     */
    Result registerTboxDeviceUser(String deviceNo, int deviceType, String deviceName, String deviceDesc);


    /**
     * 获取Tbox设备信息
     *
     * @param deviceNo
     * @param keyId
     * @return
     */
    Result getTboxDeviceInfo(String deviceNo, String keyId);


    /**
     * 发起Tbox设备签发证书申请
     *
     * @param deviceNo
     * @return
     */
    Result insertIssueCertApply(String deviceNo, String userCertDn);

    /**
     * 发起Ｔbox设备更新证书申请
     *
     * @param deviceNo     　设备编号
     * @param userCertDn   　证书dn
     * @param signSn       签名证书SN
     * @param certValidity 证书有效期
     * @param isUpdateKey  是否更新公钥
     * @return
     */
    Result insertUpdateCertApply(String deviceNo, String userCertDn, String signSn, Integer certValidity, boolean isUpdateKey);
}
