package com.xdja.pki.ra.service.manager.template;

import com.xdja.pki.ra.core.common.Result;

import java.io.IOException;

/**
 * 证书模板服务层
 *
 * @author syg
 */
public interface CertTempService {

    /**
     * 按查询条件，分页查询证书模板信息列表
     *
     * @param tempName
     * @param tempStatus
     * @param pageNo
     * @param pageSize
     * @param userCA     所属CA名称
     * @return
     */
    Result listCertTemplate(String tempName, int tempStatus, int pageNo, int pageSize, String userCA);

    /**
     * 证书模板-同步
     *
     * @param pageNo
     * @param pageSize
     * @return
     */
    Result synCertTemplateList(int pageNo, int pageSize);


    /**
     * 根据证书模板编号，修改该证书模板的审核策略
     *
     * @param tempNo
     * @param checkStrategy
     * @return
     */
    Result updateCertTempCheckStrategy(String tempNo, int checkStrategy);

    /**
     * 模板下拉框数据内容
     *
     * @return
     */
    Result listCertTemplateDropDownList(String userCA);

    /**
     * 获取证书申请可用的最大有效期
     *
     * @param tempNo
     * @param updateKey
     * @param signSn
     * @param isOnline 是否在线签发 用户证书在线签发不校验用户CA证书有效期
     * @return
     */
    Result getCertApplyMaxValidity(String tempNo, int updateKey, String signSn, boolean isOnline);

}
