package com.xdja.pki.ra.service.manager.usercert;

import com.xdja.pki.ra.core.common.Result;

import java.io.IOException;

/**
 * 用户证书服务层
 *
 * @author syg
 */
public interface UserCertService {
    /**
     * 按查询条件，分页查询用户证书信息列表
     *
     * @param certDn
     * @param userName
     * @param userType
     * @param pageNo
     * @param pageSize
     * @param leftDate 剩余有效期
     * @param effectiveTimeAsc 生效时间排序
     * @param failureTimeAsc  失效时间排序
     * @return
     */
    public Result listUserCert(String certDn, String userName, int userType, int pageNo, int pageSize, int leftDate, Boolean effectiveTimeAsc, Boolean failureTimeAsc);

    /**
     * 按查询条件，分页查询用户证书信息列表
     *
     * @param certDn
     * @param userName
     * @param userCA 所属CA名称
     * @param pageNo
     * @param pageSize
     * @param leftDate 剩余有效期
     * @param effectiveTimeAsc 生效时间排序
     * @param failureTimeAsc  失效时间排序
     * @return
     */
    Result listUserCertNew(String certDn, String userName, String userCA, int pageNo, int pageSize, int leftDate, Boolean effectiveTimeAsc, Boolean failureTimeAsc);


    /**
     * 查询证书状态
     *
     * @param certSn
     * @return
     */
    public Result getUserCertStatus(String certSn);

    /**
     * 下载用户双证书zip包
     *
     * @param certSn
     * @return
     */
    public Result exportUserDoubleCerts(String certSn);

    /**
     * 获取用户证书基本信息
     * @return
     */
    public Result getUserCertBaseInfo(String certSn);

    /**
     * 更新证书状态
     * @param certStatus
     * @param certSn
     * @return
     */
    public Result updateUserCertStatus(int certStatus,String certSn);

}