package com.xdja.pki.ra.service.manager.usercertmanager;

import com.xdja.pki.ra.core.common.Result;

/**
 * @author: ggp
 * @Date: 2019/10/30 16:58
 * @Description:
 */
public interface UserCertManagerService {
    /**
     *  查询用户证书
     * @param userType
     * @param identType
     * @param identNumber
     * @param systemFlag
     * @return
     */
    Result getUserCertInfoList(Integer userType, Integer identType,String identNumber,String systemFlag);

    /**
     * 查询证书详情
     *
     * @param certSn
     * @param systemFlag
     * @return
     */
    Result getUserCertBaseInfo(String certSn,String systemFlag);

    /**
     * 用户双证书下载
     *
     * @param signSn
     * @param systemFlag
     * @return
     */
    Result downLoadUserCertFile(String signSn,String systemFlag);

    /**
     * 根据签名证书sn获取base64格式证书
     * @param signSn
     * @param systemFlag
     * @return
     */
    Result getUserCert(String signSn,String systemFlag);
}
