/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.security.service;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.pkcs7.SignedDataUtils;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.AdminCertDao;
import com.xdja.pki.ra.manager.dao.AdminRoleDao;
import com.xdja.pki.ra.manager.dao.CaCertDao;
import com.xdja.pki.ra.manager.dao.FunctionDao;
import com.xdja.pki.ra.manager.dao.model.AdminCertDO;
import com.xdja.pki.ra.manager.dao.model.AdminRoleDO;
import com.xdja.pki.ra.manager.dao.model.CaCertDO;
import com.xdja.pki.ra.manager.dao.model.FunctionDO;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.security.bean.AuthenticationInfo;
import com.xdja.pki.ra.security.bean.Menu;
import com.xdja.pki.ra.security.service.AdminCertCardNoToken;
import com.xdja.pki.ra.security.service.SecurityService;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="securityServiceImpl")
public class SecurityServiceImpl
implements SecurityService {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    FunctionDao functionDao;
    @Autowired
    CaBusinessManager caBusinessManager;
    @Autowired
    AdminCertDao adminCertDao;
    @Autowired
    CaCertDao caCertDao;
    @Autowired
    AdminRoleDao adminRoleDao;

    @Transactional
    public AuthenticationInfo doAuthen(AuthenticationToken authToken) {
        AdminCertDO adminCertInfo;
        boolean verifyResult;
        Result result;
        AdminCertCardNoToken adminCertCardNoToken = (AdminCertCardNoToken)authToken;
        if (authToken == null) {
            throw new AuthenticationException(String.valueOf(ErrorEnum.ADMIN_LOGIN_AUTHEN_EXCEPTION.code));
        }
        String cardNo = ((AdminCertCardNoToken)authToken).getCardNo();
        String signSn = ((AdminCertCardNoToken)authToken).getSignSn();
        String challengeCode = ((AdminCertCardNoToken)authToken).getChallengeCode();
        String signData = ((AdminCertCardNoToken)authToken).getSignData();
        try {
            result = this.caBusinessManager.raAdminLoginAuthen(signSn);
        }
        catch (Exception e) {
            this.logger.error("CA\u7684\u767b\u5f55\u8ba4\u8bc1\u63a5\u53e3\u5f02\u5e38{}", (Throwable)e);
            throw new AuthenticationException(String.valueOf(ErrorEnum.CA_OPEN_API_SERVICE_EXCEPTION.code));
        }
        if (!result.isSuccess()) {
            this.logger.info("=============== CA\u670d\u52a1\u8fd4\u56de\u767b\u5f55\u8ba4\u8bc1\u5931\u8d25 =========== ");
            throw new AuthenticationException(String.valueOf(ErrorEnum.CA_SERVICE_RETURN_LOGIN_AUTHEN_ERROR.code));
        }
        Map caAuthenMap = (Map)result.getInfo();
        this.logger.info("CA\u8fd4\u56de\u7684\u8ba4\u8bc1\u4fe1\u606f ============ " + JsonUtils.object2Json((Object)caAuthenMap));
        if (CollectionUtils.isEmpty((Map)caAuthenMap)) {
            throw new AuthenticationException(String.valueOf(ErrorEnum.CA_RETURN_ADMIN_AUTHEN_INFO_IS_EMPTY.code));
        }
        int adminType = (Integer)caAuthenMap.get("adminType");
        if (Constants.ADMIN_TYPE_OTHER_0 == adminType) {
            throw new AuthenticationException(String.valueOf(ErrorEnum.ADMIN_ROLE_TYPE_IS_ERROR.code));
        }
        int signCertStatus = (Integer)caAuthenMap.get("signCertStatus");
        if (Constants.CERT_STATUS_NORMAL_1 != signCertStatus) {
            throw new AuthenticationException(String.valueOf(ErrorEnum.ADMIN_CERT_STATUS_IS_NOT_NORMAL.code));
        }
        String signCertData = (String)caAuthenMap.get("signCertData");
        PublicKey publicKey = CertUtils.getCertFromStr((String)signCertData).getPublicKey();
        this.logger.info(" ================ \u9a8c\u8bc1\u6311\u6218\u503c =============");
        try {
            verifyResult = SignedDataUtils.verifySignedData((String)signData, (PublicKey)publicKey);
        }
        catch (Exception e) {
            this.logger.error("\u5bc6\u7801\u673a\u56fd\u5bc6\u7b97\u6cd5\u5de5\u5177\u7c7b-\u9a8c\u8bc1\u7b7e\u540d-\u5f02\u5e38,{}", (Throwable)e);
            throw new AuthenticationException(String.valueOf(ErrorEnum.GMSSL_HSM_UTILS_IS_EXCEPTION.code));
        }
        if (!verifyResult) {
            this.logger.info("\u5bf9\u767b\u5f55\u7684\u6311\u6218\u503c\u8fdb\u884c\u9a8c\u7b7e\u5931\u8d25");
        }
        String encCertData = (String)caAuthenMap.get("encCertData");
        if ((adminType == Constants.ADMIN_TYPE_BUSINESS_1 || adminType == Constants.ADMIN_TYPE_AUDIT_2) && (adminCertInfo = this.adminCertDao.getAdminCertInfo(signSn, Constants.CERT_TYPE_SIGN_2)) == null) {
            this.logger.info("\u8be5sn\u3010{}\u3011\u672a\u8fdb\u884c\u8fc7\u6388\u6743\uff0c\u5c06\u8fdb\u884c\u6388\u6743\u64cd\u4f5c\uff01", (Object)signSn);
            Result authorResult = this.authorizationAdminInfo(cardNo, signCertData, encCertData, adminType, signCertStatus);
            if (!authorResult.isSuccess()) {
                this.logger.info("\u6388\u6743\u4e1a\u52a1\u7ba1\u7406\u5458\u548c\u5ba1\u8ba1\u5458\u4fe1\u606f\u51fa\u9519");
                throw new AuthenticationException(String.valueOf(authorResult.getError().code));
            }
        }
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        authenticationInfo.setAdminType(adminType);
        authenticationInfo.setSignCertStatus(signCertStatus);
        authenticationInfo.setSignCertData(signCertData);
        authenticationInfo.setEncCertData(encCertData);
        return authenticationInfo;
    }

    public Collection<Menu> getFunctions() {
        List functionDOList = this.functionDao.queryAllFunctions();
        Map<String, Menu> stringMenuMap = this.queryMapFunctions(functionDOList);
        return stringMenuMap.values();
    }

    public Collection<String> getWhiteLink() {
        ArrayList<String> links = new ArrayList<String>();
        links.add("/v1/login/manager");
        links.add("/v1/login/challenge/*");
        links.add("/v1/logout");
        links.add("/v1/init/ra/config/**");
        links.add("/v1/init/hsm/connect/**");
        links.add("/v1/init/hsm/config/**");
        links.add("/v1/init/isinit");
        links.add("/v1/init/update/*");
        links.add("/v1/init/step");
        links.add("/v1/init/recover");
        links.add("/v1/init/ca/config/**");
        links.add("/v1/init/ca/connect/**");
        links.add("/v1/init/admin/author/**");
        links.add("/v1/init/ra/system");
        links.add("/v1/init/ra/restart");
        links.add("/v1/init/ra/hsm");
        links.add("/v1/init/ra/p10");
        links.add("/v1/init/ra/certReq");
        links.add("/v1/init/hsm/no");
        links.add("/v1/init/key/name");
        links.add("/v1/init/caCert/info");
        links.add("/v1/dic/*");
        links.add("/v1/tbox/**");
        links.add("/v1/normal/**");
        links.add("/v1/ra-openapi/**");
        return links;
    }

    public String unAuthenticationContent() {
        return String.valueOf(ErrorEnum.UNAUTHENTICATED.code);
    }

    public String unAuthorizationContent() {
        return String.valueOf(ErrorEnum.UNAUTHORIZED_REQUEST.code);
    }

    public Map<String, Menu> queryMapFunctions(List<FunctionDO> functionList) {
        LinkedHashMap<String, Menu> functions = new LinkedHashMap<String, Menu>();
        LinkedHashMap<Long, Menu> tempFunctions = new LinkedHashMap<Long, Menu>();
        Menu menu = null;
        for (FunctionDO function : functionList) {
            menu = this.function2Menu(function);
            if (function.getParentId() == 0L) {
                tempFunctions.put(function.getId(), menu);
                functions.put(String.valueOf(function.getId()), menu);
                continue;
            }
            Menu parentFunc = (Menu)tempFunctions.get(function.getParentId());
            if (parentFunc != null) {
                parentFunc.addChild(menu);
            }
            tempFunctions.put(function.getId(), menu);
        }
        tempFunctions = null;
        return functions;
    }

    private Menu function2Menu(FunctionDO function) {
        Menu menu = new Menu();
        menu.setId(String.valueOf(function.getId()));
        menu.setName(function.getName());
        menu.setPermissionKey(function.getPermissionKey());
        menu.setPermission(function.getPermission());
        menu.setIcon(function.getIcon());
        menu.setLink(function.getLink());
        menu.setObjName(function.getObjName());
        menu.setOrder(function.getOrderNum().intValue());
        menu.setShow(function.getIsShow() == 1);
        return menu;
    }

    private List<Menu> sortMenuList(Collection<Menu> menuCollection) {
        ArrayList<Menu> menuList = new ArrayList<Menu>();
        menuList.addAll(menuCollection);
        Collections.sort(menuList, new MenuComparator());
        return menuList;
    }

    public Result authorizationAdminInfo(String cardNo, String signCert, String encCert, int adminType, int signCertStatus) {
        Result result = new Result();
        CaCertDO newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null) {
            this.logger.info("\u83b7\u53d6CA\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        String caDN = newCaCertInfo.getCertDn();
        long pairCertIndex = new Date().getTime();
        String roleInfo = adminType == Constants.ADMIN_TYPE_BUSINESS_1 ? "\u4e1a\u52a1\u7ba1\u7406\u5458" : "\u5ba1\u8ba1\u5458";
        AdminCertDO adminCertSignCertDO = new AdminCertDO();
        adminCertSignCertDO.setCardNo(cardNo);
        adminCertSignCertDO.setAdminType(Integer.valueOf(adminType));
        adminCertSignCertDO.setCaCertId(newCaCertInfo.getId());
        adminCertSignCertDO.setCertInfo(signCert);
        adminCertSignCertDO.setPairCertIndex(Long.valueOf(pairCertIndex));
        adminCertSignCertDO.setCertType(Integer.valueOf(Constants.CERT_TYPE_SIGN_2));
        adminCertSignCertDO.setRoleInfo(roleInfo);
        X509Certificate signCertStr = CertUtils.getCertFromStr((String)signCert);
        if (signCertStr == null) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7ba1\u7406\u5458\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u7b7e\u540d\u8bc1\u4e66\u9519\u8bef");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_ERROR);
            return result;
        }
        int publicKeyLength = 0;
        try {
            publicKeyLength = CertUtils.getPublicKeyLength((X509Certificate)signCertStr);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u516c\u94a5\u957f\u5ea6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_CERT_PUBLIC_KEY_LENGTH_EXCEPTION);
            return result;
        }
        adminCertSignCertDO.setCertSn(signCertStr.getSerialNumber().toString(16).toLowerCase());
        adminCertSignCertDO.setCertDn(signCertStr.getSubjectX500Principal().getName());
        adminCertSignCertDO.setSignAlg(signCertStr.getSigAlgName());
        adminCertSignCertDO.setCertStatus(Integer.valueOf(signCertStatus));
        adminCertSignCertDO.setPrivateKeyLength(Integer.valueOf(publicKeyLength));
        String publicKeyAlg = null;
        try {
            publicKeyAlg = CertUtils.getKeyAlg((X509Certificate)signCertStr);
            adminCertSignCertDO.setPublicKeyAlg(publicKeyAlg);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u5bc6\u94a5\u7b97\u6cd5\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_CERT_ALG_NAME_LENGTH_EXCEPTION);
            return result;
        }
        Date startDate = signCertStr.getNotBefore();
        Date endDate = signCertStr.getNotAfter();
        adminCertSignCertDO.setCertValidity(Integer.valueOf((int)(endDate.getTime() - startDate.getTime()) / 86400000));
        adminCertSignCertDO.setEffectiveTime(new Timestamp(startDate.getTime()));
        adminCertSignCertDO.setFailureTime(new Timestamp(endDate.getTime()));
        adminCertSignCertDO.setGmtCreate(new Timestamp(new Date().getTime()));
        adminCertSignCertDO.setGmtUpdate(new Timestamp(new Date().getTime()));
        AdminCertDO operatorSignCertDO = this.adminCertDao.insertAdminCert(adminCertSignCertDO);
        AdminCertDO adminCertEncCertDO = new AdminCertDO();
        adminCertEncCertDO.setCardNo(cardNo);
        adminCertEncCertDO.setAdminType(Integer.valueOf(adminType));
        adminCertEncCertDO.setCaCertId(newCaCertInfo.getId());
        adminCertEncCertDO.setCertInfo(encCert);
        adminCertEncCertDO.setPairCertIndex(Long.valueOf(pairCertIndex));
        adminCertEncCertDO.setCertType(Integer.valueOf(Constants.CERT_TYPE_ENC_3));
        adminCertEncCertDO.setRoleInfo(roleInfo);
        X509Certificate encCertStr = CertUtils.getCertFromStr((String)encCert);
        if (encCertStr == null) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7ba1\u7406\u5458\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u52a0\u5bc6\u8bc1\u4e66\u9519\u8bef");
            result.setError(ErrorEnum.CA_RESPONSE_USER_ENC_CERT_ERROR);
            return result;
        }
        adminCertEncCertDO.setCertSn(encCertStr.getSerialNumber().toString(16).toLowerCase());
        adminCertEncCertDO.setCertDn(encCertStr.getSubjectX500Principal().getName());
        adminCertEncCertDO.setSignAlg(encCertStr.getSigAlgName());
        adminCertEncCertDO.setCertStatus(Integer.valueOf(signCertStatus));
        adminCertEncCertDO.setPrivateKeyLength(Integer.valueOf(publicKeyLength));
        adminCertEncCertDO.setPublicKeyAlg(publicKeyAlg);
        adminCertEncCertDO.setCertValidity(Integer.valueOf((int)(endDate.getTime() - startDate.getTime()) / 86400000));
        adminCertEncCertDO.setEffectiveTime(new Timestamp(startDate.getTime()));
        adminCertEncCertDO.setFailureTime(new Timestamp(endDate.getTime()));
        adminCertEncCertDO.setGmtCreate(new Timestamp(new Date().getTime()));
        adminCertEncCertDO.setGmtUpdate(new Timestamp(new Date().getTime()));
        this.adminCertDao.insertAdminCert(adminCertEncCertDO);
        AdminRoleDO adminRoleDO = new AdminRoleDO(operatorSignCertDO.getId(), Long.valueOf(adminType), new Timestamp(new Date().getTime()), new Timestamp(new Date().getTime()));
        this.adminRoleDao.insertAdminRole(adminRoleDO);
        return result;
    }

    private class MenuComparator
    implements Comparator<Object> {
        private MenuComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int orderNum2;
            int orderNum1 = ((Menu)o1).getOrder();
            if (orderNum1 > (orderNum2 = ((Menu)o2).getOrder())) {
                return 1;
            }
            if (orderNum1 < orderNum2) {
                return -1;
            }
            return 0;
        }
    }
}

