/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.auditlog;

import com.xdja.pki.auditlog.service.AuditorOperateLogService;
import com.xdja.pki.auditlog.service.PeriodAuditLogService;
import com.xdja.pki.auditlog.service.bean.AuditorOperateLogResultEnum;
import com.xdja.pki.auditlog.service.bean.AuditorOperateTypeEnum;
import com.xdja.pki.core.bean.CoreResult;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PeriodAuditLogController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PeriodAuditLogService periodAuditLogService;
    @Autowired
    private AuditorOperateLogService auditorOperateLogService;

    @RequestMapping(value={"/v1/periodlog/list"}, method={RequestMethod.GET})
    public Object getPeriodAuditLogList(@RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, HttpServletResponse resp) {
        CoreResult result;
        if (StringUtils.isBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime) || StringUtils.isBlank((CharSequence)endTime) && StringUtils.isNotBlank((CharSequence)startTime)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u5206\u9875\u67e5\u8be2 \u83b7\u53d6 \u5468\u671f\u5ba1\u8ba1\u65e5\u5fd7 \u5217\u8868 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            if (pageNo == null) {
                pageNo = 1;
                pageSize = 10;
            }
            result = this.periodAuditLogService.getPeriodAuditLogList(pageNo, pageSize, startTime, endTime);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5468\u671f\u65e5\u5fd7\u5ba1\u8ba1\u5217\u8868\u6570\u636e\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("PeriodAuditLogController.getPeriodAuditLogList>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/periodlog/auditloglist"}, method={RequestMethod.GET})
    public Object getAuditLogInfo(@RequestParam(value="id") int id, HttpServletResponse resp) {
        CoreResult result;
        try {
            result = this.periodAuditLogService.getAuditLogList(id);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u65e5\u5fd7\u5ba1\u8ba1\u8be6\u60c5\u6570\u636e\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess() && null != result.getErrorBean()) {
            return result.resp(resp, result);
        }
        this.logger.info("AuditController.getAuditLogInfo>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/periodlog/verify"}, method={RequestMethod.GET})
    public Object verifyPeriodAuditLog(@RequestParam int id, HttpServletResponse resp) {
        CoreResult result;
        StringBuffer auditContext = new StringBuffer();
        try {
            int auditResult;
            this.logger.info("audit log verify id = {}", (Object)id);
            result = this.periodAuditLogService.verify(id);
            if (result.isSuccess()) {
                auditResult = AuditorOperateLogResultEnum.SUCCESS.id;
                auditContext.append("\u9a8c\u7b7e\u65e5\u5fd7\u6210\u529f");
            } else {
                auditResult = AuditorOperateLogResultEnum.FAIL.id;
                auditContext.append("\u9a8c\u7b7e\u65e5\u5fd7\u5931\u8d25");
            }
            try {
                boolean flag = this.auditorOperateLogService.saveAuditorOperateLog(AuditorOperateTypeEnum.VERIFY_LOG.type, auditContext.toString(), auditResult);
                if (!flag) {
                    this.logger.error("\u8bb0\u5f55\u5ba1\u8ba1\u5458\u9a8c\u7b7e\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u5ba1\u8ba1\u5458\u9a8c\u7b7e\u65e5\u5fd7\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5ba1\u8ba1\u65e5\u5fd7\u9a8c\u7b7e\u5931\u8d25\uff01", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess() && null != result.getErrorBean()) {
            return result.resp(resp, result);
        }
        this.logger.info("PeriodAuditLogController.verifyPeriodAuditLog>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }
}

