/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.certapply;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dto.IssueApplyDTO;
import com.xdja.pki.ra.service.manager.certapply.IssueApplyService;
import com.xdja.pki.ra.web.manager.certapply.bean.IssueApplyReq;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IssueCertApplyController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IssueApplyService issueApplyService;
    @Autowired
    AuditLogService auditLogService;

    @RequestMapping(value={"/v1/user/cert/apply/issue/{applyNo}"}, method={RequestMethod.GET})
    public Object getIssueCertApplyInfo(@PathVariable String applyNo, HttpServletResponse resp) {
        Result result;
        this.logger.info("IssueCertApplyController.getIssueCertApplyInfo>>>>>>applyNo:" + applyNo);
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.issueApplyService.getIssueApplyInfo(applyNo);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u8be6\u60c5\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("IssueCertApplyController.getIssueCertApplyInfo>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/cert/apply/issue"}, method={RequestMethod.POST})
    public Object insertUserCertIssueApply(@Valid @RequestBody IssueApplyReq issueApplyReq, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        this.logger.info("IssueCertApplyController.insertUserCertIssueApply>>>>>>issueApplyReq:" + JsonUtils.object2Json((Object)issueApplyReq));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u53d1\u8d77\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        IssueApplyDTO issueApplyDTO = new IssueApplyDTO();
        BeanUtils.copyProperties((Object)issueApplyReq, (Object)issueApplyDTO);
        Result result = this.issueApplyService.insertUserCertIssueApply(null, issueApplyDTO, false, false);
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u53d1\u8d77\u7528\u6237\u8bc1\u4e66\u7b7e\u53d1\u7533\u8bf7\u3010\u5931\u8d25\u3011");
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.SUBMIT_APPLY.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u53d1\u8d77\u7528\u6237\u8bc1\u4e66\u7b7e\u53d1\u7533\u8bf7\u3010\u6210\u529f\u3011");
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.SUBMIT_APPLY.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("IssueCertApplyController.insertUserCertIssueApply>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/cert/apply/issue/{applyNo}"}, method={RequestMethod.POST})
    public Object updateUserCertIssueApply(@PathVariable String applyNo, @Valid @RequestBody IssueApplyReq issueApplyReq, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("IssueCertApplyController.updateUserCertIssueApply>>>>>>applyNo:" + applyNo + " issueApplyReq:" + JsonUtils.object2Json((Object)issueApplyReq));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u4fee\u6539\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            IssueApplyDTO issueApplyDTO = new IssueApplyDTO();
            BeanUtils.copyProperties((Object)issueApplyReq, (Object)issueApplyDTO);
            result = this.issueApplyService.updateUserCertIssueApply(null, applyNo, issueApplyDTO, false, false);
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u8be6\u60c5\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4fee\u6539\u7528\u6237\u7b7e\u53d1\u8bc1\u4e66\u3010\u5931\u8d25\u3011\uff0c\u7533\u8bf7\u7f16\u53f7=").append(applyNo).append("\uff0c\u8bc1\u4e66\u4e3b\u4f53=" + issueApplyReq.getCertDn());
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.UPDATE_APPLY.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4fee\u6539\u7528\u6237\u7b7e\u53d1\u8bc1\u4e66\u3010\u6210\u529f\u3011\uff0c\u7533\u8bf7\u7f16\u53f7=").append(applyNo).append("\uff0c\u8bc1\u4e66\u4e3b\u4f53=" + issueApplyReq.getCertDn());
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.UPDATE_APPLY.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("IssueCertApplyController.updateUserCertIssueApply>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }
}

