/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.certapply;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dto.RecoveryApplyDTO;
import com.xdja.pki.ra.service.manager.certapply.RecoveryApplyService;
import com.xdja.pki.ra.web.manager.certapply.bean.RecoveryApplyReq;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RecoveryCertApplyController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    AuditLogService auditLogService;
    @Autowired
    RecoveryApplyService recoveryApplyService;

    @RequestMapping(value={"/v1/user/cert/apply/recovery/{applyNo}"}, method={RequestMethod.GET})
    public Object getRecoveryCertApplyInfo(@PathVariable String applyNo, HttpServletResponse resp) {
        this.logger.info("RecoveryCertApplyController.getRecoveryCertApplyInfo>>>>>>applyNo:" + applyNo);
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        Result result = new Result();
        try {
            result = this.recoveryApplyService.getRecoveryApplyInfo(applyNo);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6062\u590d\u8bc1\u4e66\u7533\u8bf7\u8be6\u60c5\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("RecoveryCertApplyController.getRecoveryCertApplyInfo>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/cert/apply/recovery"}, method={RequestMethod.POST})
    public Object insertUserCertRecoveryApply(@Valid @RequestBody RecoveryApplyReq recoveryApplyReq, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        this.logger.info("RecoveryCertApplyController.insertUserCertRecoveryApply>>>>>>recoveryApplyReq:" + JsonUtils.object2Json((Object)recoveryApplyReq));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u53d1\u8d77\u6062\u590d\u8bc1\u4e66\u7533\u8bf7\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        RecoveryApplyDTO recoveryApplyDTO = new RecoveryApplyDTO();
        BeanUtils.copyProperties((Object)recoveryApplyReq, (Object)recoveryApplyDTO);
        Result result = this.recoveryApplyService.insertUserCertRecoveryApply(null, recoveryApplyDTO, false);
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u53d1\u8d77\u7528\u6237\u8bc1\u4e66\u6062\u590d\u7533\u8bf7\u3010\u5931\u8d25\u3011\uff0c\u8bc1\u4e66\u4e3b\u4f53=").append(recoveryApplyReq.getCertDn());
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getError().desc);
            this.auditLogService.save(AuditLogOperatorTypeEnum.SUBMIT_APPLY.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u53d1\u8d77\u7528\u6237\u8bc1\u4e66\u6062\u590d\u7533\u8bf7\u3010\u6210\u529f\u3011\uff0c\u8bc1\u4e66\u4e3b\u4f53=").append(recoveryApplyReq.getCertDn());
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.SUBMIT_APPLY.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("RecoveryCertApplyController.insertUserCertRecoveryApply>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }
}

