/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.customer;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.exception.ServiceException;
import com.xdja.pki.ra.core.util.file.ZipUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.service.manager.cert.CertService;
import com.xdja.pki.ra.service.manager.customer.CustomerSysService;
import com.xdja.pki.ra.service.manager.customer.bean.CustomerCertIssueApplyVO;
import com.xdja.pki.ra.service.manager.customer.bean.CustomerSysVO;
import com.xdja.pki.ra.service.manager.customer.bean.CustomerTemplateSaveVO;
import com.xdja.pki.ra.web.manager.certapply.bean.ErrorMsgReq;
import com.xdja.pki.ra.web.manager.operator.bean.RevokeOperatorCertReq;
import java.io.File;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CustomerSysController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CustomerSysService customerSysService;
    @Autowired
    AuditLogService auditLogService;
    @Autowired
    CertService certService;

    @RequestMapping(value={"/v1/client"}, method={RequestMethod.GET})
    public Object getCustomerSysPageInfo(@RequestParam(value="systemNumber", required=false) String systemNumber, @RequestParam(value="systemName", required=false) String systemName, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="pageNo") int pageNo, HttpServletResponse resp) {
        this.logger.info("CustomerSysController.getCustomerSysPageInfo>>>>>>systemNumber = " + systemNumber + "systemName = " + systemName);
        if (pageNo <= 0) {
            pageNo = 1;
        }
        Result result = this.customerSysService.getCustomerInfoList(systemNumber, systemName, pageSize, pageNo);
        this.logger.info("CustomerSysController.getCustomerSysPageInfo>>>>>>  result :" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/client"}, method={RequestMethod.POST})
    public Object registerCustomerSys(@Valid @RequestBody CustomerSysVO customerSysVO, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        this.logger.info("CustomerSysController.registerCustomerSys>>>>>>customerSysVO = " + customerSysVO.toString());
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u7b2c\u4e09\u65b9\u6ce8\u518c\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        Result result = this.customerSysService.registerCustomerInfo(customerSysVO);
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u6ce8\u518c\u7b2c\u4e09\u65b9\u7cfb\u7edf\u4fe1\u606f\u3010\u5931\u8d25\u3011\uff0c\u7cfb\u7edf\u540d\u79f0=").append(customerSysVO.getCustomerSysName()).append("\uff0c\u7cfb\u7edf\u6807\u8bc6=" + customerSysVO.getCustomerSysNumber()).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.THIRD_PARTY_SYSTEM.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u6ce8\u518c\u7b2c\u4e09\u65b9\u7cfb\u7edf\u4fe1\u606f\u3010\u6210\u529f\u3011\uff0c\u7cfb\u7edf\u540d\u79f0=").append(customerSysVO.getCustomerSysName()).append("\uff0c\u7cfb\u7edf\u6807\u8bc6=" + customerSysVO.getCustomerSysNumber());
        this.auditLogService.save(AuditLogOperatorTypeEnum.THIRD_PARTY_SYSTEM.type, logContent.toString(), logResult, bean.getSign());
        return result;
    }

    @RequestMapping(value={"/v1/client/{id}"}, method={RequestMethod.GET})
    public Object getCustomerSysInfo(@PathVariable String id, HttpServletResponse resp) {
        this.logger.info("CustomerSysController.getCustomerSysInfo>>>>>>id = " + id);
        Result result = this.customerSysService.getCustomerInfo(Integer.valueOf(id));
        this.logger.info("CustomerSysController.getCustomerSysPageInfo>>>>>>  result :" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/client/{id}"}, method={RequestMethod.PUT})
    public Object updateCustomerSysInfo(@PathVariable String id, @Valid @RequestBody CustomerSysVO customerSysVO, AuditSignBean bean, HttpServletResponse resp) {
        this.logger.info("CustomerSysController.updateCustomerSysInfo>>>>>>customerSysVO = " + customerSysVO.toString());
        if (null == customerSysVO || StringUtils.isBlank((CharSequence)customerSysVO.getCustomerSysNumber()) || StringUtils.isBlank((CharSequence)customerSysVO.getCustomerSysName())) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        Result result = this.customerSysService.updateCustomerInfo(Integer.valueOf(id), customerSysVO);
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4fee\u6539\u7b2c\u4e09\u65b9\u7cfb\u7edf\u4fe1\u606f\u3010\u5931\u8d25\u3011\uff0c\u7cfb\u7edf\u540d\u79f0=").append(customerSysVO.getCustomerSysName()).append("\uff0c\u7cfb\u7edf\u6807\u8bc6=" + customerSysVO.getCustomerSysNumber()).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.THIRD_PARTY_SYSTEM.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4fee\u6539\u7b2c\u4e09\u65b9\u7cfb\u7edf\u4fe1\u606f\u3010\u6210\u529f\u3011\uff0c\u7cfb\u7edf\u540d\u79f0=").append(customerSysVO.getCustomerSysName()).append("\uff0c\u7cfb\u7edf\u6807\u8bc6=" + customerSysVO.getCustomerSysNumber());
        this.auditLogService.save(AuditLogOperatorTypeEnum.THIRD_PARTY_SYSTEM.type, logContent.toString(), logResult, bean.getSign());
        return result;
    }

    @Deprecated
    @RequestMapping(value={"/v1/client/cert/maxValidity/{tempNo}"}, method={RequestMethod.GET})
    public Object getCustomerMaxValidity(@PathVariable String tempNo, HttpServletResponse resp) {
        Result result;
        try {
            result = this.customerSysService.getCertMaxValidity(tempNo);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u53ef\u7b7e\u53d1\u7684\u6700\u5927\u6709\u6548\u671f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/client/certs"}, method={RequestMethod.GET})
    public Object getCustomerCertPageInfo(@RequestParam(value="systemName", required=false) String systemName, @RequestParam(value="certDN", required=false) String certDn, @RequestParam(value="status", required=false) String status, @RequestParam(value="order", required=false) String order, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="pageNo") int pageNo, HttpServletResponse resp) {
        Result result;
        this.logger.info("CustomerSysController.getCustomerCertPageInfo>>>>>>systemName = " + systemName + "certDn = " + certDn + "status = " + status + "order = " + order);
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (!(result = this.customerSysService.getCustomerCertInfoList(systemName, certDn, status, order, pageSize, pageNo)).isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CustomerSysController.getCustomerCertPageInfo>>>>>>  result :" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/client/temp/{customsysid}"}, method={RequestMethod.GET})
    public Object getCustomerTemplateById(@PathVariable String customsysid, HttpServletResponse resp) {
        Result result;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{customsysid})) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.customerSysService.getCustomerTemplateById(Long.valueOf(customsysid));
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u8be2\u7b2c\u4e09\u65b9\u6388\u6743\u6a21\u677f\u4fe1\u606f\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/client/temp"}, method={RequestMethod.PUT})
    public Object saveCustomerTemplates(@Valid @RequestBody CustomerTemplateSaveVO customerTemplateSaveVO, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        try {
            result = this.customerSysService.saveCustomerTemplates(customerTemplateSaveVO);
        }
        catch (ServiceException e) {
            this.logger.error("\u4fdd\u5b58\u7b2c\u4e09\u65b9\u6388\u6743\u6a21\u677f\u4fe1\u606f\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6388\u6743\u6a21\u677f\u3010\u5931\u8d25\u3011").append(result.getLogContent()).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.THIRD_PARTY_SYSTEM.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6388\u6743\u6a21\u677f\u3010\u6210\u529f\u3011").append(result.getLogContent());
        this.auditLogService.save(AuditLogOperatorTypeEnum.THIRD_PARTY_SYSTEM.type, logContent.toString(), logResult, bean.getSign());
        return result;
    }

    @RequestMapping(value={"/v1/client/temp/select/{customerId}"}, method={RequestMethod.GET})
    public Object getCustomerTemplateSelectList(@PathVariable Long customerId, HttpServletResponse resp) {
        Result result;
        try {
            result = this.customerSysService.getCustomerTemplateSelectList(customerId);
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u8be2\u7b2c\u4e09\u65b9\u6388\u6743\u6a21\u677f\u4fe1\u606f\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/client/certs"}, method={RequestMethod.POST})
    public Object genCustomerCertByKeyStore(@RequestBody CustomerCertIssueApplyVO customerCertIssueApplyVO, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("CustomerSysController.genCustomerCertByKeyStore>>>>>> customerCertIssueApplyVO:{} ", (Object)JsonUtils.object2Json((Object)customerCertIssueApplyVO));
        if (null == customerCertIssueApplyVO || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{customerCertIssueApplyVO.getCustomerSysNumber(), customerCertIssueApplyVO.getCertDn(), customerCertIssueApplyVO.getSignAlg(), customerCertIssueApplyVO.getTempNo()}) || null == customerCertIssueApplyVO.getCertValidity() || null == customerCertIssueApplyVO.getPrivateKeyLength() || null == customerCertIssueApplyVO.getCustomerSysId()) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.customerSysService.issCustomerCertByKeyStore(customerCertIssueApplyVO);
        }
        catch (Exception e) {
            this.logger.error("\u4ee5keyStore\u65b9\u5f0f\u7b7e\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u7b7e\u53d1\u3010\u5931\u8d25\u3011\uff0c\u8bc1\u4e66DN=" + customerCertIssueApplyVO.getCertDn()).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.THIRD_PARTY_SYSTEM.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u7b7e\u53d1\u3010\u6210\u529f\u3011\uff0c\u8bc1\u4e66DN=" + customerCertIssueApplyVO.getCertDn()).append(result.getLogContent());
        this.auditLogService.save(AuditLogOperatorTypeEnum.THIRD_PARTY_SYSTEM.type, logContent.toString(), logResult, bean.getSign());
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/client/certs/{certSn}"}, method={RequestMethod.GET})
    public Object getClientSystemCertInfo(@PathVariable String certSn, HttpServletResponse resp) {
        Result result;
        this.logger.info("CustomerSysController.getClientSystemCertInfo>>>>>> certSn:{}", (Object)certSn);
        try {
            result = this.customerSysService.getCustomerCertInfo(certSn);
        }
        catch (Exception e) {
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CustomerSysController.getClientSystemCertInfo>>>>>result:{}", (Object)JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/client/certs/file/{systemFlag}/{certSn}"}, method={RequestMethod.GET})
    public Object exportClientSystemDoubleCerts(@PathVariable String systemFlag, AuditSignBean bean, @PathVariable String certSn, HttpServletResponse resp) {
        this.logger.info("CustomerSysController.exportClientSystemDoubleCerts>>>>>>systemFlag:" + systemFlag + " certSn:" + certSn);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{systemFlag, certSn})) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            String zipPath = PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "/" + certSn;
            File file = new File(zipPath);
            if (!file.exists()) {
                return ErrorEnum.FILE_IS_NOT_EXIST.resp(resp);
            }
            String fileName = "DeviceCert_" + systemFlag;
            byte[] data = ZipUtils.createZipByFile((String)zipPath, (String)fileName);
            resp.setContentType("application/octet-stream");
            resp.setCharacterEncoding("UTF-8");
            resp.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".zip");
            ServletOutputStream out = resp.getOutputStream();
            IOUtils.write((byte[])data, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fazip\u538b\u7f29\u5305\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            return ErrorEnum.MAKE_ZIP_FILE_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        logContent.append("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u4e0b\u8f7d\u3010\u6210\u529f\u3011\uff0c\u7b7e\u540d\u8bc1\u4e66SN=").append(certSn);
        this.auditLogService.save(AuditLogOperatorTypeEnum.THIRD_PARTY_SYSTEM.type, logContent.toString(), AuditLogResultEnum.SUCCESS.id, bean.getSign());
        this.logger.info("CustomerSysController.exportClientSystemDoubleCerts>>>>>>end");
        return null;
    }

    @RequestMapping(value={"/v1/client/certs/confirm/{tranId}/{signCertSn}"}, method={RequestMethod.POST})
    public Object genManagerCertResp(@PathVariable String tranId, @PathVariable String signCertSn, HttpServletResponse resp) {
        Result result;
        this.logger.info("CustomerSysController.genManagerCertResp>>>>>>tranId:{},signCertSn:{} ", (Object)tranId, (Object)signCertSn);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tranId, signCertSn})) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.customerSysService.genCertConfirm(tranId, signCertSn);
        }
        catch (Exception e) {
            this.logger.error("\u7b7e\u53d1\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66-\u54cd\u5e94-\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CustomerSysController.genManagerCertResp>>>>>>result:{}", (Object)JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/client/certs/error/{tranId}"}, method={RequestMethod.POST})
    public Object genErrorMsgContent(@PathVariable String tranId, @Valid @RequestBody ErrorMsgReq errorMsgReq, BindingResult bindResult, HttpServletResponse resp) {
        Result result;
        this.logger.info("CustomerSysController.genErrorMsgContent>>>>>>tranId:" + tranId);
        if (StringUtils.isBlank((CharSequence)tranId)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u53d1\u9001\u9519\u8bef\u54cd\u5e94\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.customerSysService.genErrorMsgContent(tranId, errorMsgReq.getErrorCode(), errorMsgReq.getErrorMsg());
        }
        catch (Exception e) {
            this.logger.error("\u9519\u8bef-\u54cd\u5e94-\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CustomerSysController.genErrorMsgContent>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/client/certs/{signSn}"}, method={RequestMethod.POST})
    public Object revokeRaOperatorCert(@PathVariable String signSn, @Valid @RequestBody RevokeOperatorCertReq revokeOperatorCertReq, AuditSignBean bean, BindingResult bindResult, HttpServletResponse resp) {
        Result result;
        this.logger.info("CustomerSysController.revokeRaOperatorCert>>>>>>revokeOperatorCertReq:" + JsonUtils.object2Json((Object)revokeOperatorCertReq));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u64a4\u9500\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.customerSysService.revokeCustomerCert(signSn, revokeOperatorCertReq.getCertDn(), revokeOperatorCertReq.getRevokeType(), revokeOperatorCertReq.getRevokeReason());
        }
        catch (Exception e) {
            this.logger.error("\u64a4\u9500\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u64a4\u9500\u3010\u5931\u8d25\u3011").append("\uff0c\u8bc1\u4e66DN=" + revokeOperatorCertReq.getCertDn() + "\uff0c\u7b7e\u540d\u8bc1\u4e66SN=" + signSn).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.THIRD_PARTY_SYSTEM.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u64a4\u9500\u3010\u6210\u529f\u3011").append("\uff0c\u8bc1\u4e66DN=" + revokeOperatorCertReq.getCertDn() + "\uff0c\u7b7e\u540d\u8bc1\u4e66SN=" + signSn);
        this.auditLogService.save(AuditLogOperatorTypeEnum.THIRD_PARTY_SYSTEM.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("CustomerSysController.revokeRaOperatorCert>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/client/verifyDN"}, method={RequestMethod.GET})
    public Object verifyClientCertDn(@RequestParam(value="systemFlag") String systemFlag, @RequestParam(value="certDn") String certDn, HttpServletResponse resp) {
        Result result;
        this.logger.info("ClientController.verifyClientCertDn>>>>>>systemFlag:" + systemFlag + " certDn:" + certDn);
        if (StringUtils.isBlank((CharSequence)certDn)) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.customerSysService.verifyClientCertDn(systemFlag, certDn);
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u8bc1\u4e66\u7533\u8bf7DN\u6709\u6548\u6027\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("ClientController.verifyClientCertDn>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/client/verifyName"}, method={RequestMethod.GET})
    public Object verifyCustomerSysName(@RequestParam Boolean isUpdate, @RequestParam(value="id", required=false) Integer id, @RequestParam String systemName, HttpServletResponse resp) {
        Result result;
        this.logger.info("CustomerSysController.verifyCustomerSysName>>>>>>systemName:" + systemName);
        if (StringUtils.isBlank((CharSequence)systemName)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (isUpdate.booleanValue() && null == id) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.customerSysService.verifyCustomerSysName(isUpdate, id, systemName);
        }
        catch (Exception e) {
            this.logger.error("\u6ce8\u518c\u7b2c\u4e09\u65b9\u7cfb\u7edf--\u7cfb\u7edf\u540d\u79f0\u552f\u4e00\u6027\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CustomerSysController.verifyCustomerSysName>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/client/verifyNumber"}, method={RequestMethod.GET})
    public Object verifyCustomerSysNumber(@RequestParam String systemNumber, HttpServletResponse resp) {
        Result result;
        this.logger.info("CustomerSysController.verifyCustomerSysNumber>>>>>>systemNumber:" + systemNumber);
        if (StringUtils.isBlank((CharSequence)systemNumber)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.customerSysService.verifyCustomerSysNumber(systemNumber);
        }
        catch (Exception e) {
            this.logger.error("\u6ce8\u518c\u7b2c\u4e09\u65b9\u7cfb\u7edf--\u7cfb\u7edf\u6807\u8bc6\u552f\u4e00\u6027\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CustomerSysController.verifyCustomerSysNumber>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }
}

