/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.init;

import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.service.manager.init.InitService;
import com.xdja.pki.ra.service.manager.system.CaService;
import com.xdja.pki.ra.service.manager.system.HsmServer;
import com.xdja.pki.ra.service.manager.system.RaServer;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class InitController {
    @Autowired
    InitService initService;
    @Autowired
    CaService caService;
    @Autowired
    HsmServer hsmServer;
    @Autowired
    RaServer raServer;
    @Autowired
    CaBusinessManager caBusinessManager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/v1/init/ra/config"}, method={RequestMethod.POST})
    public Object initSaveRaController(@RequestParam(value="keyIndex", required=false) Integer keyIndex, @RequestParam(value="priKeyPwd", required=false) String priKeyPwd, @RequestParam(value="certChain") MultipartFile certChain, @RequestParam(value="enc") MultipartFile enc, HttpServletResponse resp) {
        this.logger.info("InitController.initSaveRaController>>>>>>keyIndex: " + keyIndex + " priKeyPwd: " + priKeyPwd);
        if (1 == CommonVariable.getIsHsm() && "SM2".equalsIgnoreCase(CommonVariable.getKeyAlgName()) && (StringUtils.isBlank((CharSequence)priKeyPwd) || keyIndex == null)) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        Result result = this.raServer.initRaServerConfig(keyIndex, priKeyPwd, certChain, enc);
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/hsm/connect"}, method={RequestMethod.POST})
    public Object initTestHsmController(@RequestParam(value="hsmServerIp") String hsmServerIp, @RequestParam(value="hsmServerPort") int hsmServerPort, @RequestParam(value="signCertPwd") String signCertPwd, @RequestParam(value="encCertPwd") String encCertPwd, @RequestParam(value="sign") MultipartFile sign, @RequestParam(value="enc") MultipartFile enc, @RequestParam(value="certChain") MultipartFile certChain, HttpServletResponse resp) {
        this.logger.info("InitController.initTestHsmController>>>>>>hsmServerIp  " + hsmServerIp + "  hsmServerPort: " + hsmServerPort + " encCertPwd\uff1a " + encCertPwd + " signCertPwd\uff1a " + signCertPwd);
        Result result = new Result();
        if (!(sign.getContentType().equals("application/x-pkcs12") && enc.getContentType().equals("application/x-pkcs12") && certChain.getContentType().equals("application/x-pkcs7-certificates"))) {
            this.logger.info("\u8bc1\u4e66\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
            result.setError(ErrorEnum.HSM_CERT_ERROR);
            return result;
        }
        Result stepResult = this.initService.getOperateStep();
        this.logger.info("\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a========" + stepResult.getInfo());
        if (!stepResult.getInfo().equals(0)) {
            this.logger.info("\u521d\u59cb\u5316\u6b65\u9aa4\u6570\u9519\u8bef");
            return ErrorEnum.INIT_STEP_ERROR.resp(resp);
        }
        result = this.hsmServer.testHsmConnect(hsmServerIp, hsmServerPort, signCertPwd, encCertPwd, sign, enc, certChain);
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("\u5bc6\u7801\u673a\u521d\u59cb\u5316\u8fde\u63a5\u6d4b\u8bd5\uff1a\u5bc6\u7801\u673a\u8fde\u63a5\u6210\u529f\u300b\u300b\u300b\u300b\u300b\u300b");
        result.setInfo((Object)1);
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/hsm/config"}, method={RequestMethod.POST})
    public Object initSaveHsmController(@RequestParam(value="hsmServerIp") String hsmServerIp, @RequestParam(value="hsmServerPort") int hsmServerPort, @RequestParam(value="encCertPwd") String encCertPwd, @RequestParam(value="signCertPwd") String signCertPwd, @RequestParam(value="sign") MultipartFile sign, @RequestParam(value="enc") MultipartFile enc, @RequestParam(value="certChain") MultipartFile certChain, HttpServletResponse resp) {
        this.logger.info("InitController.initSaveRaController>>>>>>RaServerConfigInfo: hsmServerIp  " + hsmServerIp + "  hsmServerPort: " + hsmServerPort + " encCertPwd\uff1a " + encCertPwd + " signCertPwd\uff1a " + signCertPwd);
        Result result = new Result();
        if (!(sign.getContentType().equals("application/x-pkcs12") && enc.getContentType().equals("application/x-pkcs12") && certChain.getContentType().equals("application/x-pkcs7-certificates"))) {
            this.logger.info("\u8bc1\u4e66\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
            result.setError(ErrorEnum.HSM_CERT_ERROR);
            return result;
        }
        Result stepResult = this.initService.getOperateStep();
        this.logger.info("\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a========" + stepResult.getInfo());
        if (!stepResult.getInfo().equals(0)) {
            this.logger.info("\u521d\u59cb\u5316\u6b65\u9aa4\u6570\u9519\u8bef");
            return ErrorEnum.INIT_STEP_ERROR.resp(resp);
        }
        result = this.hsmServer.initHsmServer(hsmServerIp, hsmServerPort, signCertPwd, encCertPwd, sign, enc, certChain);
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/isinit"}, method={RequestMethod.GET})
    public Object isInitialized(HttpServletResponse resp) {
        Result result;
        this.logger.info("InitController.isInitialized>>>>>>start");
        try {
            result = this.initService.isInitialized();
        }
        catch (Exception e) {
            this.logger.error("\u5224\u65ad\u7cfb\u7edf\u662f\u5426\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        this.logger.info("InitController.isInitialized>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @Deprecated
    @RequestMapping(value={"/v1/init/update/{status}"}, method={RequestMethod.PUT})
    public Object updateDeviceInitStatus(@PathVariable Integer status, HttpServletResponse resp) {
        this.logger.info("InitController.updateDeviceInitStatus>>>>>>status:" + status);
        if (1 != status && 0 != status) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        Result result = this.initService.updateDeviceInitStatus(status);
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("InitController.updateDeviceInitStatus>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/step"}, method={RequestMethod.GET})
    public Object getOperateStep(HttpServletResponse resp) {
        Result result;
        this.logger.info("InitController.getOperateStep>>>>>>start");
        try {
            result = this.initService.getOperateStep();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u521d\u59cb\u5316\u8bb0\u5f55\u6b65\u9aa4\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        this.logger.info("InitController.getOperateStep>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/recover"}, method={RequestMethod.PUT})
    public Object initDeviceRecover(HttpServletResponse resp, HttpServletRequest req) {
        Result result;
        this.logger.info("InitController.initDeviceRecover>>>>>>start");
        String clientIpAddress = this.getClientIpAddress(req);
        this.logger.info("\u5ba2\u6237\u7aef\u7684ip\u5730\u5740\u4e3a\uff1a" + clientIpAddress);
        try {
            result = this.initService.initDeviceRecover();
        }
        catch (Exception e) {
            this.logger.error("\u91cd\u65b0\u5f00\u59cb\u521d\u59cb\u5316\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("InitController.initDeviceRecover>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/ca/config/{caServerIp}/{caServerPort}"}, method={RequestMethod.POST})
    public Object configCaServer(@RequestParam(value="file") MultipartFile file, @PathVariable String caServerIp, @PathVariable int caServerPort, HttpServletResponse resp) {
        Result result;
        this.logger.info("InitController.configCaServer>>>>>>caServerIp:" + caServerIp + " caServerPort:" + caServerPort);
        if (StringUtils.isBlank((CharSequence)caServerIp) || 0 == caServerPort || caServerPort > 65535) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (!file.getOriginalFilename().endsWith("p7b")) {
            this.logger.info("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
            return ErrorEnum.FILE_TYPE_ERROR.resp(resp);
        }
        if (file.getSize() < 0L || file.getSize() > 51200L) {
            this.logger.info("\u4e0a\u4f20\u8bc1\u4e66\u94fe\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1b" + file.getSize() / 1024L + "kb");
            return ErrorEnum.CERT_SIZE_IS_ERROR.resp(resp);
        }
        try {
            result = this.caService.configCaServer(file, caServerIp, caServerPort);
        }
        catch (Exception e) {
            this.logger.error("\u914d\u7f6eCA\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("InitController.configCaServer>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/ca/connect/{caServerIp}/{caServerPort}"}, method={RequestMethod.POST})
    public Object testCaServerConnect(@RequestParam(value="file") MultipartFile file, @PathVariable String caServerIp, @PathVariable int caServerPort, HttpServletResponse resp) {
        Result result;
        this.logger.info("InitController.testCaServerConnect>>>>>>caServerIp:" + caServerIp + " caServerPort:" + caServerPort);
        if (StringUtils.isBlank((CharSequence)caServerIp) || caServerPort <= 0) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (!file.getOriginalFilename().endsWith("p7b")) {
            this.logger.info("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
            return ErrorEnum.FILE_TYPE_ERROR.resp(resp);
        }
        if (file.getSize() < 0L || file.getSize() > 51200L) {
            this.logger.info("\u4e0a\u4f20\u8bc1\u4e66\u94fe\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1b" + file.getSize() / 1024L + "kb");
            return ErrorEnum.CERT_SIZE_IS_ERROR.resp(resp);
        }
        Result stepResult = this.initService.getOperateStep();
        this.logger.info("\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a========" + stepResult.getInfo());
        if (!stepResult.getInfo().equals(1)) {
            this.logger.info("\u521d\u59cb\u5316\u6b65\u9aa4\u6570\u9519\u8bef");
            return ErrorEnum.INIT_STEP_ERROR.resp(resp);
        }
        try {
            result = this.caBusinessManager.testCaServerConnect(file, caServerIp, caServerPort);
        }
        catch (Exception e) {
            this.logger.error("\u6d4b\u8bd5CA\u670d\u52a1\u8fde\u901a\u6027\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("InitController.testCaServerConnect>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/encrypt/localkey"}, method={RequestMethod.POST})
    public Object genLocalEncryptKey(HttpServletResponse resp) {
        this.logger.info("InitController.genLocalEncryptKey>>>>>>\u6536\u5230\u751f\u6210\u52a0\u5bc6\u5bf9\u79f0\u5bc6\u94a5\u8bf7\u6c42");
        if (1 == CommonVariable.getIsHsm()) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            Result result = this.initService.genLocalEncryptKey();
            this.logger.debug("\u751f\u6210\u52a0\u5bc6\u5bf9\u79f0\u5bc6\u94a5\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u52a0\u5bc6\u5bf9\u79f0\u5bc6\u94a5\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/encrypt/key"}, method={RequestMethod.POST})
    public Object genEncryptKey(HttpServletResponse resp, @RequestBody Map<String, Integer> param) {
        this.logger.info("InitController.genEncryptKey>>>>>>keyIndex:" + param.get("keyIndex"));
        if (1 == CommonVariable.getIsHsm() && param.get("keyIndex") == null) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            Result result = this.initService.genEncryptKey(param.get("keyIndex"));
            this.logger.debug("\u751f\u6210\u52a0\u5bc6\u5bf9\u79f0\u5bc6\u94a5\u4e0b\u4e00\u6b65\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            if (!result.isSuccess()) {
                return result.resp(resp, result);
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u52a0\u5bc6\u5bf9\u79f0\u5bc6\u94a5\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/admin/author/{adminType}/{cardNo}/{signSn}"}, method={RequestMethod.POST})
    public Object authorizeAdmin(@PathVariable int adminType, @PathVariable String cardNo, @PathVariable String signSn, HttpServletResponse resp) {
        this.logger.info("InitController.authorizeAdmin>>>>>>adminType:" + adminType + " cardNo:" + cardNo + " signSn:" + signSn);
        if (1 != adminType && 2 != adminType) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        Result result = this.initService.authorizeAdmin(signSn, cardNo, adminType);
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("InitController.authorizeAdmin>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/ra/system"}, method={RequestMethod.GET})
    public Object initRaServer(HttpServletResponse resp) {
        this.logger.info("InitController.initRaServer>>>>>>start");
        Result result = this.initService.initRaSystem();
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("InitController.initRaServer>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/ra/restart"}, method={RequestMethod.GET})
    public Object restartRaServer(HttpServletResponse resp) {
        this.logger.info("InitController.restartRaServer>>>>>>start");
        Result result = this.initService.restartTomcat();
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("InitController.restartRaServer>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/ra/p10"}, method={RequestMethod.POST})
    public Object genRaServerCertP10(@RequestParam String certDn, @RequestParam int keyLength, HttpServletResponse resp) {
        this.logger.info("InitController.genRaServerCertP10>>>>>>certDn:" + certDn + " keyLength:" + keyLength);
        Result result = null;
        try {
            result = this.raServer.genRaServerCertP10(certDn, keyLength, CommonVariable.getKeyAlgName(), true);
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210RA\u670d\u52a1\u5668\u8bc1\u4e66\u7533\u8bf7\u4e66\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("InitController.genRaServerCertP10>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/ra/hsm"}, method={RequestMethod.GET})
    public Object getDeviceIsUseHsmInfo(HttpServletResponse resp) {
        this.logger.info("InitController.getDeviceIsUseHsmInfo>>>>>>start");
        Result result = this.raServer.isUseHsmInfo();
        this.logger.info("InitController.getDeviceIsUseHsmInfo>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/ra/certReq"}, method={RequestMethod.GET})
    public Object getRaServerCertReq(@RequestParam String zipFileName, HttpServletResponse resp) throws Exception {
        Result result;
        this.logger.info("InitController.getRaServerCertReq>>>>>>zipFileName:" + zipFileName);
        int index = zipFileName.indexOf("?");
        if (index != -1) {
            zipFileName = zipFileName.substring(0, index);
        }
        if (!(result = this.raServer.downloadRaServerCertReq(zipFileName)).isSuccess()) {
            return result.resp(resp, result);
        }
        try {
            byte[] certReq = (byte[])result.getInfo();
            resp.setContentType("application/octet-stream");
            resp.setCharacterEncoding("UTF-8");
            resp.setHeader("Content-Disposition", "attachment; filename=" + zipFileName);
            ServletOutputStream out = resp.getOutputStream();
            IOUtils.write((byte[])certReq, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7dRA\u670d\u52a1\u5668\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            throw new Exception(e);
        }
        return null;
    }

    protected String getClientIpAddress(HttpServletRequest request) {
        String clientIp = request.getHeader("x-forwarded-for");
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getHeader("Proxy-Client-IP");
        }
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getHeader("WL-Proxy-Client-IP");
        }
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getRemoteAddr();
        }
        return clientIp;
    }

    @RequestMapping(value={"/v1/init/hsm/no"}, method={RequestMethod.POST})
    public Object isHsm(HttpServletResponse resp) {
        Result result;
        this.logger.info("InitController.isHsm>>>>>>start");
        try {
            result = this.hsmServer.isHsm();
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u4e0d\u914d\u7f6e\u5bc6\u7801\u673a\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        this.logger.info("InitController.isHsm>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return null;
    }

    @RequestMapping(value={"/v1/init/key/name"}, method={RequestMethod.GET})
    public Object getKeyAlgName(HttpServletResponse resp) {
        Result result;
        this.logger.info("InitController.getKeyAlgName>>>>>>start");
        try {
            result = this.initService.getSystemKeyAlgName();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7cfb\u7edf\u79d8\u94a5\u7b97\u6cd5\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("InitController.getKeyAlgName>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/caCert/info"}, method={RequestMethod.POST})
    public Object getCaCertInfo(@RequestParam(value="trustFile") MultipartFile file, HttpServletResponse resp) {
        Result result;
        this.logger.info("InitController.getCaCertInfo>>>>>>start");
        if (!file.getOriginalFilename().endsWith("p7b")) {
            this.logger.info("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
            return ErrorEnum.FILE_TYPE_ERROR.resp(resp);
        }
        if (file.getSize() < 0L || file.getSize() > 51200L) {
            this.logger.info("\u4e0a\u4f20\u8bc1\u4e66\u94fe\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1b" + file.getSize() / 1024L + "kb");
            return ErrorEnum.CERT_SIZE_IS_ERROR.resp(resp);
        }
        try {
            result = this.caService.getVerifyCaCertInfo(file, false);
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u5bfc\u5165CA\u8bc1\u4e66\u94fe\u83b7\u53d6\u4fe1\u606f", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("InitController.getCaCertInfo>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/swxahsm/config"}, method={RequestMethod.POST})
    public Object initSwxaHsm(@RequestParam(value="hsmServerIp") String hsmServerIp, @RequestParam(value="hsmServerPort") int hsmServerPort, @RequestParam(value="accessPassword") String accessPassword, HttpServletResponse resp) {
        this.logger.info("InitController.initSwxaHsm>>>>>>hsmServerIp  " + hsmServerIp + "  hsmServerPort: " + hsmServerPort + " accessPassword\uff1a " + accessPassword);
        Result result = this.hsmServer.saveSwxaHsm(hsmServerIp, hsmServerPort, accessPassword, false);
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/swxahsm/connect"}, method={RequestMethod.POST})
    public Object testSwxaHsm(@RequestParam(value="hsmServerIp") String hsmServerIp, @RequestParam(value="hsmServerPort") int hsmServerPort, @RequestParam(value="accessPassword") String accessPassword, HttpServletResponse resp) {
        this.logger.info("InitController.testSwxaHsm>>>>>>hsmServerIp  " + hsmServerIp + "  hsmServerPort: " + hsmServerPort + " accessPassword\uff1a " + accessPassword);
        Result result = this.hsmServer.testSwxaHsmConnect(hsmServerIp, hsmServerPort, accessPassword, false);
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("SWXA-\u5bc6\u7801\u673a\u521d\u59cb\u5316\u8fde\u63a5\u6d4b\u8bd5\uff1a\u5bc6\u7801\u673a\u8fde\u63a5\u6210\u529f\u300b\u300b\u300b\u300b\u300b\u300b");
        result.setInfo((Object)1);
        return result.getInfo();
    }
}

