/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.operator;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.file.ZipUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dto.AdminCertDTO;
import com.xdja.pki.ra.service.manager.operator.OperatorCertService;
import com.xdja.pki.ra.web.manager.certapply.bean.ErrorMsgReq;
import com.xdja.pki.ra.web.manager.operator.bean.CertConfirmReq;
import com.xdja.pki.ra.web.manager.operator.bean.InsertOperatorCertReq;
import com.xdja.pki.ra.web.manager.operator.bean.RevokeOperatorCertReq;
import com.xdja.pki.ra.web.manager.operator.bean.UpdateOperatorCertReq;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OperatorCertController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    OperatorCertService operatorCertService;
    @Autowired
    AuditLogService auditLogService;

    @RequestMapping(value={"/v1/manager/ra/operator"}, method={RequestMethod.GET})
    public Object queryRaOperatorCertList(@RequestParam(value="certDn", required=false) String certDn, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize, HttpServletResponse resp) {
        Result result;
        this.logger.info("OperatorCertController.listOperatorCert>>>>>>certDn:" + certDn + " pageNo:" + pageNo + " pageSize:" + pageSize);
        if (pageNo <= 0) {
            pageNo = 1;
        }
        try {
            result = this.operatorCertService.queryOperatorCertList(certDn, pageNo, pageSize);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u64cd\u4f5c\u5458\u8bc1\u4e66\u5217\u8868\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("OperatorCertController.listOperatorCert>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/manager/ra/operator/info/{certSn}/{certType}"}, method={RequestMethod.GET})
    public Object getRaOperatorCertDetail(@PathVariable String certSn, @PathVariable int certType, HttpServletResponse resp) {
        Result result;
        this.logger.info("OperatorCertController.getRaOperatorCertDetail>>>>>>certSn:" + certSn + " certType:" + certType);
        if (certType != 2 && certType != 3) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.operatorCertService.getOperatorCertDetail(certSn, certType);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7ba1\u7406\u5458\u8bc1\u4e66\u8be6\u60c5\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("OperatorCertController.getRaOperatorCertDetail>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/manager/ra/operator/info/{signSn}"}, method={RequestMethod.GET})
    public Object getRaOperatorCertInfo(@PathVariable String signSn, HttpServletResponse resp) {
        Result result;
        this.logger.info("OperatorCertController.getRaOperatorCertInfo>>>>>>signSn:" + signSn);
        try {
            result = this.operatorCertService.getOperatorCertInfo(signSn);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7ba1\u7406\u5458\u8bc1\u4e66\u57fa\u672c\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("OperatorCertController.getRaOperatorCertInfo>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/manager/ra/operator/temp"}, method={RequestMethod.GET})
    public Object getRaOperatorCertTemp(HttpServletResponse resp) {
        Result result;
        this.logger.info("OperatorCertController.getRaOperatorCertTemp>>>>>>start");
        try {
            result = this.operatorCertService.getRaOperatorCertTemp();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6RA\u7684\u7ba1\u7406\u5458\u6a21\u677f\u4fe1\u606f-\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("OperatorCertController.getRaOperatorCertTemp>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/manager/ra/operator/temp/validity"}, method={RequestMethod.GET})
    public Object getOperatorCertMaxValidity(@RequestParam(value="updateKey", required=false) Integer updateKey, @RequestParam(value="signSn", required=false) String signSn, HttpServletResponse resp) {
        Result result;
        this.logger.info("OperatorCertController.getCertApplyMaxValidity>>>>>> updateKey:" + updateKey + " signSn:" + signSn);
        if (updateKey == null) {
            updateKey = 1;
        }
        if (updateKey == 0 && signSn == null) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.operatorCertService.getOperatorCertMaxValidity(updateKey.intValue(), signSn);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6RA\u64cd\u4f5c\u5458\u8bc1\u4e66\u6a21\u677f\u6700\u5927\u6709\u6548\u671f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess() && null != result.getError()) {
            return result.resp(resp, result);
        }
        this.logger.info("OperatorCertController.getCertApplyMaxValidity>>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/manager/ra/operator/{signSn}"}, method={RequestMethod.GET})
    public Object exportRaOperatorCert(@PathVariable String signSn, AuditSignBean bean, HttpServletResponse resp) throws Exception {
        Result result;
        this.logger.info("OperatorCertController.exportRaOperatorCert>>>>>>signSn:" + signSn);
        try {
            result = this.operatorCertService.getOperatorCertBase64Info(signSn);
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7d\u64cd\u4f5c\u5458\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4e0b\u8f7d\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u3010\u5931\u8d25\u3011\uff0c\u7b7e\u540d\u8bc1\u4e66SN=").append(signSn);
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_DOWNLOAD.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4e0b\u8f7d\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u3010\u6210\u529f\u3011\uff0c\u7b7e\u540d\u8bc1\u4e66SN=").append(signSn);
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_DOWNLOAD.type, logContent.toString(), logResult, bean.getSign());
        try {
            List list = (List)result.getInfo();
            byte[] data = ZipUtils.generateZipByte((List)list);
            resp.setContentType("application/octet-stream");
            resp.setCharacterEncoding("UTF-8");
            resp.setHeader("Content-Disposition", "attachment; filename=MangerCert_" + signSn + ".zip");
            ServletOutputStream out = resp.getOutputStream();
            IOUtils.write((byte[])data, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7d\u64cd\u4f5c\u5458\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            throw new Exception(e);
        }
        this.logger.info("OperatorCertController.exportRaOperatorCert>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/manager/ra/operator"}, method={RequestMethod.POST})
    public Object insertRaOperatorCert(@RequestBody InsertOperatorCertReq insertOperatorCertReq, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("OperatorCertController.insertRaOperatorCert>>>>>>insertOperatorCertReq:" + JsonUtils.object2Json((Object)insertOperatorCertReq));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u65b0\u589eRA\u7684\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (insertOperatorCertReq.getRoles().contains(3) && insertOperatorCertReq.getRoles().contains(4)) {
            return ErrorEnum.OPERATOR_ROLE_CANNOT_INPUT_AND_AUDIT.resp(resp);
        }
        try {
            AdminCertDTO adminCertDTO = new AdminCertDTO();
            BeanUtils.copyProperties((Object)insertOperatorCertReq, (Object)adminCertDTO);
            result = this.operatorCertService.insertOperatorCert(adminCertDTO);
        }
        catch (Exception e) {
            this.logger.error("\u65b0\u589e\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u7b7e\u53d1\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u3010\u5931\u8d25\u3011\uff0c\u8bc1\u4e66\u4e3b\u4f53=").append(insertOperatorCertReq.getCertDn()).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_ISSUE.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u7b7e\u53d1\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u3010\u6210\u529f\u3011\uff0c\u8bc1\u4e66\u4e3b\u4f53=").append(insertOperatorCertReq.getCertDn());
        this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_ISSUE.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("OperatorCertController.insertRaOperatorCert>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/manager/ra/operator/{signSn}"}, method={RequestMethod.PUT})
    public Object updateRaOperatorCert(@PathVariable String signSn, @Valid @RequestBody UpdateOperatorCertReq updateOperatorCertReq, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("OperatorCertController.updateRaOperatorCert>>>>>>updateOperatorCertReq:" + JsonUtils.object2Json((Object)updateOperatorCertReq));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u66f4\u65b0RA\u7684\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (updateOperatorCertReq.isUpdateKey() && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{updateOperatorCertReq.getEncPubKey(), updateOperatorCertReq.getSignP10()})) {
            this.logger.info("\u66f4\u65b0\u5bc6\u94a5\u65f6\uff0c\u7b7e\u540dP10\u548c\u52a0\u5bc6\u516c\u94a5\u5185\u5bb9\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            AdminCertDTO adminCertDTO = new AdminCertDTO();
            BeanUtils.copyProperties((Object)updateOperatorCertReq, (Object)adminCertDTO);
            adminCertDTO.setManagerTempNo(updateOperatorCertReq.getTempNo());
            adminCertDTO.setSignCertSn(signSn);
            result = this.operatorCertService.updateOperatorCert(adminCertDTO);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u66f4\u65b0\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u3010\u5931\u8d25\u3011\uff0c\u8bc1\u4e66\u4e3b\u4f53=").append(updateOperatorCertReq.getCertDn()).append("\uff0c\u8bc1\u4e66SN=" + signSn).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_UPDATE.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u66f4\u65b0\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u3010\u6210\u529f\u3011\uff0c\u8bc1\u4e66\u4e3b\u4f53=").append(updateOperatorCertReq.getCertDn()).append("\uff0c\u8bc1\u4e66SN=" + signSn);
        this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_UPDATE.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("OperatorCertController.updateRaOperatorCert>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/manager/ra/operator/{signSn}"}, method={RequestMethod.POST})
    public Object revokeRaOperatorCert(@PathVariable String signSn, @Valid @RequestBody RevokeOperatorCertReq revokeOperatorCertReq, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("OperatorCertController.revokeRaOperatorCert>>>>>>revokeOperatorCertReq:" + JsonUtils.object2Json((Object)revokeOperatorCertReq));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u64a4\u9500RA\u7684\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.operatorCertService.revokeOperatorCert(signSn, revokeOperatorCertReq.getCertDn(), revokeOperatorCertReq.getRevokeType(), revokeOperatorCertReq.getRevokeReason());
        }
        catch (Exception e) {
            this.logger.error("\u64a4\u9500\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u64a4\u9500\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u3010\u5931\u8d25\u3011\uff0c\u8bc1\u4e66\u4e3b\u4f53=").append(revokeOperatorCertReq.getCertDn()).append("\uff0c\u8bc1\u4e66SN=" + signSn).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_REVOKED.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u64a4\u9500\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u3010\u6210\u529f\u3011\uff0c\u8bc1\u4e66\u4e3b\u4f53=").append(revokeOperatorCertReq.getCertDn()).append("\uff0c\u8bc1\u4e66SN=" + signSn);
        this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_REVOKED.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("OperatorCertController.revokeRaOperatorCert>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/manager/ra/operator/confirm/{tranId}"}, method={RequestMethod.POST})
    public Object genManagerCertResp(@PathVariable String tranId, @RequestBody CertConfirmReq certConfirmReq, BindingResult bindResult, HttpServletResponse resp) {
        Result result;
        this.logger.info("OperatorCertController.genManagerCertResp>>>>>>tranId:" + tranId);
        if (StringUtils.isBlank((CharSequence)tranId)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.operatorCertService.genCertConfirm(tranId, certConfirmReq.getSignSn(), certConfirmReq.getEncSn(), certConfirmReq.getEncCert());
        }
        catch (Exception e) {
            this.logger.error("\u901a\u8fc7\u5b89\u5168\u5361\u7b7e\u53d1\u7ba1\u7406\u5458\u8bc1\u4e66-\u54cd\u5e94-\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("OperatorCertController.genManagerCertResp>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/manager/ra/operator/verifyDN"}, method={RequestMethod.GET})
    public Object verifyOperatorCertApplyDn(@RequestParam(value="certDn") String certDn, HttpServletResponse resp) {
        Result result;
        this.logger.info("OperatorCertController.verifyOperatorCertApplyDn>>>>>>certDn:" + certDn);
        if (StringUtils.isBlank((CharSequence)certDn)) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.operatorCertService.verifyOperatorCertApplyDn(certDn);
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u8bc1\u4e66\u7533\u8bf7DN\u6709\u6548\u6027\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("OperatorCertController.verifyOperatorCertApplyDn>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/manager/ra/operator/error/{tranId}"}, method={RequestMethod.POST})
    public Object genErrorMsgContent(@PathVariable String tranId, @Valid @RequestBody ErrorMsgReq errorMsgReq, BindingResult bindResult, HttpServletResponse resp) {
        Result result;
        this.logger.info("OperatorCertController.genErrorMsgContent>>>>>>tranId:" + tranId);
        if (StringUtils.isBlank((CharSequence)tranId)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u53d1\u9001\u9519\u8bef\u54cd\u5e94\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.operatorCertService.genErrorMsgContent(tranId, errorMsgReq.getErrorCode(), errorMsgReq.getErrorMsg());
        }
        catch (Exception e) {
            this.logger.error("\u9519\u8bef-\u54cd\u5e94-\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CertApplyController.genErrorMsgContent>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }
}

