/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.scep;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.exception.ServiceException;
import com.xdja.pki.ra.service.manager.scep.ScepDeviceService;
import com.xdja.pki.ra.service.manager.scep.bean.ScepDeviceVO;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ScepDeviceController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    AuditLogService auditLogService;
    @Autowired
    ScepDeviceService scepDeviceService;

    @RequestMapping(value={"/v1/device/scep"}, method={RequestMethod.GET})
    public Object getScepDevicePageInfo(@RequestParam(value="scepName", required=false) String scepName, @RequestParam(value="scepChallenge", required=false) String scepChallenge, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="pageNo") int pageNo, HttpServletResponse resp) {
        Result result;
        this.logger.info("ScepDeviceController.getScepDevicePageInfo>>>>>>scepName = " + scepName + " scepChallenge = " + scepChallenge);
        if (pageNo <= 0) {
            pageNo = 1;
        }
        try {
            result = this.scepDeviceService.getScepDeviceList(scepName, scepChallenge, Integer.valueOf(pageSize), Integer.valueOf(pageNo));
        }
        catch (Exception e) {
            this.logger.error("SCEP\u8bbe\u5907\u7ba1\u7406\u5217\u8868\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        this.logger.info("ScepDeviceController.getScepDevicePageInfo>>>>>>  end");
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/device/scep"}, method={RequestMethod.POST})
    public Object registerScepDevice(@RequestBody ScepDeviceVO scepDeviceVO, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("ScepDeviceController.registerScepDevice>>>>>>scepDeviceVO = " + scepDeviceVO.toString());
        try {
            result = this.scepDeviceService.registerScepInfo(scepDeviceVO);
        }
        catch (Exception e) {
            this.logger.error("\u6ce8\u518cSCEP\u8bbe\u5907\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u6ce8\u518cSCEP\u8bbe\u5907\u4fe1\u606f\u5931\u8d25\u3011\uff0c\u8bbe\u5907\u540d\u79f0=").append(scepDeviceVO.getScepName()).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.SCEP_DEVICE_MANAGER.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u6ce8\u518cSCEP\u8bbe\u5907\u4fe1\u606f\u3010\u6210\u529f\u3011\uff0c\u7cfb\u7edf\u540d\u79f0=").append(scepDeviceVO.getScepName());
        this.auditLogService.save(AuditLogOperatorTypeEnum.SCEP_DEVICE_MANAGER.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("ScepDeviceController.registerScepDevice>>>>>>  end");
        return result;
    }

    @Deprecated
    @RequestMapping(value={"/v1/device/scep/{id}"}, method={RequestMethod.GET})
    public Object getScepDeviceInfo(@PathVariable String id, HttpServletResponse resp) {
        this.logger.info("ScepDeviceController.getScepDeviceInfo>>>>>>id = " + id);
        Result result = this.scepDeviceService.getScepInfo(Long.valueOf(id));
        this.logger.info("ScepDeviceController.getScepDeviceInfo>>>>>>  end");
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/device/scep/verifyName"}, method={RequestMethod.GET})
    public Object verifyScepDeviceName(@RequestParam String scepName, HttpServletResponse resp) {
        Result result;
        this.logger.info("ScepDeviceController.verifyScepDeviceName>>>>>>scepName:" + scepName);
        if (StringUtils.isBlank((CharSequence)scepName)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.scepDeviceService.verifyScepDeviceName(scepName);
        }
        catch (Exception e) {
            this.logger.error("\u6ce8\u518cSCEP\u8bbe\u5907\u7ba1\u7406--\u7cfb\u7edf\u540d\u79f0\u552f\u4e00\u6027\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("ScepDeviceController.verifyScepDeviceName>>>>>>  end");
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/device/scep/temp/{id}"}, method={RequestMethod.GET})
    public Object getScepTemplateById(@PathVariable String id, HttpServletResponse resp) {
        Result result;
        this.logger.info("ScepDeviceController.getScepTemplateById>>>>>>id:" + id);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{id})) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.scepDeviceService.getScepTemplateById(Long.valueOf(id));
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u8be2scep\u8bbe\u5907\u6388\u6743\u6a21\u677f\u4fe1\u606f\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        this.logger.info("ScepDeviceController.getScepTemplateById>>>>>>  end");
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/device/scep/temp/{id}/{tempNo}"}, method={RequestMethod.POST})
    public Object saveScepTemplate(@PathVariable String id, @PathVariable String tempNo, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("ScepDeviceController.saveScepTemplate>>>>>>id:" + id);
        try {
            result = this.scepDeviceService.saveScepTemplate(Long.valueOf(id), tempNo);
        }
        catch (ServiceException e) {
            this.logger.error("\u4fdd\u5b58scep\u8bbe\u5907\u6388\u6743\u6a21\u677f\u4fe1\u606f\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("scep\u8bbe\u5907\u6388\u6743\u6a21\u677f\u3010\u5931\u8d25\u3011").append(result.getLogContent()).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.SCEP_DEVICE_MANAGER.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("scep\u8bbe\u5907\u6388\u6743\u6a21\u677f\u3010\u6210\u529f\u3011").append(result.getLogContent());
        this.auditLogService.save(AuditLogOperatorTypeEnum.SCEP_DEVICE_MANAGER.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("ScepDeviceController.saveScepTemplate>>>>>>  end");
        return result;
    }

    @RequestMapping(value={"/v1/device/scep/temp/inner"}, method={RequestMethod.GET})
    public Object getScepTemplateInner(HttpServletResponse resp) {
        Result result;
        this.logger.info("ScepDeviceController.getScepTemplateInner>>>>>> ");
        try {
            result = this.scepDeviceService.getScepTemplateInner();
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u8be2scep\u8bbe\u5907\u5185\u7f6e\u6a21\u677f\u4fe1\u606f\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        this.logger.info("ScepDeviceController.getScepTemplateInner>>>>>>  end");
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/device/scep/temp/inner/{tempNo}"}, method={RequestMethod.POST})
    public Object saveScepInnerTemplate(@PathVariable String tempNo, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("ScepDeviceController.saveScepInnerTemplate>>>>>>tempNo\uff1a" + tempNo);
        try {
            result = this.scepDeviceService.saveScepInnerTemplate(tempNo);
        }
        catch (ServiceException e) {
            this.logger.error("\u4fdd\u5b58scep\u8bbe\u5907\u6388\u6743\u6a21\u677f\u4fe1\u606f\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("scep\u8bbe\u5907\u7ba1\u7406\u8bbe\u7f6e\u9ed8\u8ba4\u6a21\u677f\u3010\u5931\u8d25\u3011").append("\uff0c\u9ed8\u8ba4\u6a21\u677f\u7f16\u53f7" + tempNo).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.SCEP_DEVICE_MANAGER.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("scep\u8bbe\u5907\u7ba1\u7406\u8bbe\u7f6e\u9ed8\u8ba4\u6a21\u677f\u3010\u6210\u529f\u3011").append("\uff0c\u9ed8\u8ba4\u6a21\u677f\u7f16\u53f7" + tempNo);
        this.auditLogService.save(AuditLogOperatorTypeEnum.SCEP_DEVICE_MANAGER.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("ScepDeviceController.saveScepInnerTemplate>>>>>>  end");
        return result;
    }
}

