/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.system;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.service.manager.init.InitService;
import com.xdja.pki.ra.service.manager.system.CaService;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class CaServerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CaService caService;
    @Autowired
    InitService initService;
    @Autowired
    CaBusinessManager caBusinessManager;
    @Autowired
    AuditLogService auditLogService;

    @RequestMapping(value={"/v1/system/ca/info"}, method={RequestMethod.GET})
    public Object getCaConfigInfo(HttpServletResponse resp) {
        Result result;
        this.logger.info("CaServerController.getCaConfigInfo>>>>>>start");
        try {
            result = this.caService.getCaConfigInfo();
        }
        catch (Exception e) {
            this.logger.error("CA\u670d\u52a1\u914d\u7f6e\u8be6\u60c5\u83b7\u53d6\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CaServerController.getCaConfigInfo>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/system/ca/config/{caServerIp}/{caServerPort}"}, method={RequestMethod.PUT})
    public Object updateConfigCaServer(@RequestParam(value="file", required=false) MultipartFile file, @PathVariable String caServerIp, @PathVariable int caServerPort, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("CaServerController.updateConfigCaServer>>>>>>caServerIp:" + caServerIp + " caServerPort:" + caServerPort);
        if (StringUtils.isBlank((CharSequence)caServerIp) || caServerPort <= 0 || caServerPort > 65535) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (null == file) {
            result = this.caService.updateLessCAServer(caServerIp, caServerPort);
        } else {
            if (!file.getOriginalFilename().endsWith("p7b")) {
                this.logger.info("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
                return ErrorEnum.FILE_TYPE_ERROR.resp(resp);
            }
            if (file.getSize() < 0L || file.getSize() > 51200L) {
                this.logger.info("\u4e0a\u4f20\u8bc1\u4e66\u94fe\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1b" + file.getSize() / 1024L + "kb");
                return ErrorEnum.CERT_SIZE_IS_ERROR.resp(resp);
            }
            try {
                result = this.caService.updateConfigCaServer(file, caServerIp, caServerPort);
            }
            catch (Exception e) {
                this.logger.error("CA\u670d\u52a1\u914d\u7f6e\u66f4\u65b0\u5f02\u5e38", (Throwable)e);
                return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
            }
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4fee\u6539CA\u670d\u52a1\u914d\u7f6e\u3010\u5931\u8d25\u3011\uff0cCA\u670d\u52a1IP=").append(caServerIp).append("\uff0cCA\u670d\u52a1\u7aef\u53e3=").append(caServerPort).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_CONFIG_UPDATE.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4fee\u6539CA\u670d\u52a1\u914d\u7f6e\u3010\u6210\u529f\u3011\uff0cCA\u670d\u52a1IP=").append(caServerIp).append("\uff0cCA\u670d\u52a1\u7aef\u53e3=").append(caServerPort);
        this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_CONFIG_UPDATE.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("CaServerController.updateConfigCaServer>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/system/ca/connect/{caServerIp}/{caServerPort}"}, method={RequestMethod.POST})
    public Object testCaServerConnect(@RequestParam(value="file", required=false) MultipartFile file, @PathVariable String caServerIp, @PathVariable int caServerPort, HttpServletResponse resp) {
        Result result;
        this.logger.info("CaServerController.testCaServerConnect>>>>>>caServerIp:" + caServerIp + " caServerPort:" + caServerPort);
        if (StringUtils.isBlank((CharSequence)caServerIp) || caServerPort <= 0 || caServerPort > 65535) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (file != null) {
            if (!file.getOriginalFilename().endsWith("p7b")) {
                this.logger.info("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
                return ErrorEnum.FILE_TYPE_ERROR.resp(resp);
            }
            if (file.getSize() < 0L || file.getSize() > 51200L) {
                this.logger.info("\u4e0a\u4f20\u8bc1\u4e66\u94fe\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1b" + file.getSize() / 1024L + "kb");
                return ErrorEnum.CERT_SIZE_IS_ERROR.resp(resp);
            }
        }
        try {
            result = this.caBusinessManager.testCaServerConnect(file, caServerIp, caServerPort);
        }
        catch (Exception e) {
            this.logger.error("\u6d4b\u8bd5CA\u670d\u52a1\u8fde\u901a\u6027\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CaServerController.testCaServerConnect>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/system/ra/restart"}, method={RequestMethod.GET})
    public Object restartRaServer(HttpServletResponse resp) {
        this.logger.info("CaServerController.restartRaServer>>>>>>start");
        Result result = this.initService.restartTomcat();
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CaServerController.restartRaServer>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/system/caCert/info"}, method={RequestMethod.POST})
    public Object getCaCertInfo(@RequestParam(value="trustFile") MultipartFile file, HttpServletResponse resp) {
        Result result;
        this.logger.info("CaServerController.getCaCertInfo>>>>>>start");
        if (!file.getOriginalFilename().endsWith("p7b")) {
            this.logger.info("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
            return ErrorEnum.FILE_TYPE_ERROR.resp(resp);
        }
        if (file.getSize() < 0L || file.getSize() > 51200L) {
            this.logger.info("\u4e0a\u4f20\u8bc1\u4e66\u94fe\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1b" + file.getSize() / 1024L + "kb");
            return ErrorEnum.CERT_SIZE_IS_ERROR.resp(resp);
        }
        try {
            result = this.caService.getVerifyCaCertInfo(file, true);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u914d\u7f6e\u5bfc\u5165CA\u8bc1\u4e66\u94fe\u83b7\u53d6\u4fe1\u606f", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CaServerController.getCaCertInfo>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }
}

