/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.system;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.service.manager.system.RaServer;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class RaServerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    RaServer raServer;
    @Autowired
    AuditLogService auditLogService;

    @AuditSign
    @RequestMapping(value={"/v1/system/ra/config"}, method={RequestMethod.POST})
    public Object raServerUpdateConfig(@RequestParam(value="keyIndex", required=false) Integer keyIndex, @RequestParam(value="priKeyPwd", required=false) String priKeyPwd, @RequestParam(value="certChain") MultipartFile certChain, @RequestParam(value="enc") MultipartFile enc, AuditSignBean bean, HttpServletResponse resp) {
        this.logger.info("RaServerController.raServerUpdateConfig>>>>>>keyIndex: " + keyIndex + " priKeyPwd: " + priKeyPwd);
        Result result = this.raServer.updateRaServerConfig(keyIndex, priKeyPwd, certChain, enc);
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u66f4\u65b0RA\u670d\u52a1\u5668\u8bc1\u4e66\u3010\u5931\u8d25\u3011");
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_UPDATE.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u66f4\u65b0RA\u670d\u52a1\u5668\u8bc1\u4e66\u3010\u6210\u529f\u3011");
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_UPDATE.type, logContent.toString(), logResult, bean.getSign());
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/system/ra/cert/info/{certType}"}, method={RequestMethod.GET})
    public Object raServerCertDetails(@PathVariable int certType, HttpServletResponse resp) {
        this.logger.info("RaServerController.raServerCertDetails>>>>>>certType: " + certType);
        Result result = this.raServer.getRaServerCertDetails(certType);
        if (!result.isSuccess()) {
            this.logger.info("\u67e5\u770b\u670d\u52a1\u5668\u8bc1\u4e66\u8be6\u60c5\u9519\u8bef");
            return result.resp(resp, result);
        }
        this.logger.info("RaServerController.raServerCertDetails>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @Deprecated
    @RequestMapping(value={"/v1/system/ra/config/details"}, method={RequestMethod.GET})
    public Object getRaServerConfigDetails(HttpServletResponse resp) {
        this.logger.info("RaServerController.getRaServerConfigDetails>>>>>> ");
        Result result = this.raServer.getRaServerConfigInfo();
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/system/ra/hsm"}, method={RequestMethod.GET})
    public Object getDeviceIsUseHsmInfo(HttpServletResponse resp) {
        this.logger.info("RaServerController.getDeviceIsUseHsmInfo>>>>>>start");
        Result result = this.raServer.isUseHsmInfo();
        this.logger.info("RaServerController.getDeviceIsUseHsmInfo>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/system/ra/p10"}, method={RequestMethod.POST})
    public Object genRaServerCertP10(@RequestParam String certDn, @RequestParam int keyLength, HttpServletResponse resp) {
        this.logger.info("RaServerController.genRaServerCertP10>>>>>>certDn:" + certDn);
        Result result = null;
        try {
            result = this.raServer.genRaServerCertP10(certDn, keyLength, CommonVariable.getKeyAlgName(), false);
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210RA\u670d\u52a1\u5668\u8bc1\u4e66\u7533\u8bf7\u4e66\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("RaServerController.genRaServerCertP10>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/system/ra/certReq"}, method={RequestMethod.GET})
    public Object getRaServerCertReq(@RequestParam String zipFileName, HttpServletResponse resp) throws Exception {
        this.logger.info("RaServerController.getRaServerCertReq>>>>>>zipFileName:" + zipFileName);
        int index = zipFileName.indexOf("?");
        zipFileName = zipFileName.substring(0, index);
        Result result = this.raServer.downloadRaServerCertReq(zipFileName);
        try {
            byte[] certReq = (byte[])result.getInfo();
            resp.setContentType("application/octet-stream");
            resp.setCharacterEncoding("UTF-8");
            resp.setHeader("Content-Disposition", "attachment; filename=" + zipFileName);
            ServletOutputStream out = resp.getOutputStream();
            IOUtils.write((byte[])certReq, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7dRA\u670d\u52a1\u5668\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            throw new Exception(e);
        }
        return null;
    }
}

