/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.user;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.ErrorBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.service.manager.baseuser.BaseUserService;
import com.xdja.pki.ra.service.manager.deviceuser.DeviceUserService;
import com.xdja.pki.ra.service.manager.organuser.OrganUserService;
import com.xdja.pki.ra.service.manager.personuser.PersonUserService;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class BaseUserController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int MAX_FILE_SIZE = 0x100000;
    @Autowired
    BaseUserService baseUserService;
    @Autowired
    OrganUserService organUserService;
    @Autowired
    PersonUserService personUserService;
    @Autowired
    DeviceUserService deviceUserService;
    @Autowired
    WebApplicationContext webApplicationConnect;
    @Autowired
    AuditLogService auditLogService;

    @AuditSign
    @RequestMapping(value={"/v1/user/person/save/template/{userType}"}, method={RequestMethod.POST})
    public Object batchUserByTemplateFile(@RequestParam(value="file") MultipartFile file, @PathVariable int userType, AuditSignBean bean, HttpServletResponse resp) {
        int logResult;
        this.logger.info("BaseUserController.batchUserByTemplateFile>>>>>>file:" + file.getSize() + "k userType:" + userType);
        if (1 != userType && 2 != userType && 3 != userType) {
            this.logger.info("\u6279\u91cf\u6ce8\u518c\u7528\u6237\u5931\u8d25");
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (file.getSize() > 0x100000L) {
            this.logger.info("\u6587\u4ef6\u5927\u5c0f\u662f\uff1a" + file.getSize() + "k");
            return ErrorEnum.TEMP_FILE_SIZE_IS_GREATER_1_MB.resp(resp);
        }
        Result result = new Result();
        ArrayList lists = new ArrayList();
        try {
            HSSFWorkbook wb;
            if (file.getOriginalFilename().endsWith("xls")) {
                wb = new HSSFWorkbook(file.getInputStream());
            } else if (file.getOriginalFilename().endsWith("xlsx")) {
                wb = new XSSFWorkbook(file.getInputStream());
            } else {
                this.logger.info("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
                return ErrorEnum.FILE_TYPE_ERROR.resp(resp);
            }
            Sheet sheet = wb.getSheetAt(0);
            int firstRowIndex = sheet.getFirstRowNum() + 3;
            int lastRowIndex = sheet.getLastRowNum();
            int userIndex = lastRowIndex - 3 + 1;
            this.logger.info("\u672c\u6b21\u5171\u4e0a\u4f20\u7528\u6237\u6761\u6570\u4e3a\uff1a" + userIndex);
            if (5000 < userIndex) {
                return ErrorEnum.GREATER_THAN_EXCEL_MAX_SIZE.resp(resp);
            }
            int lastCellIndex = sheet.getRow(2).getLastCellNum();
            for (int rIndex = firstRowIndex; rIndex <= lastRowIndex; ++rIndex) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Row row = sheet.getRow(rIndex);
                if (row == null) continue;
                for (int cIndex = 0; cIndex < lastCellIndex; ++cIndex) {
                    Cell cell = row.getCell(cIndex);
                    if (cell == null) {
                        arrayList.add("");
                        continue;
                    }
                    cell.setCellType(1);
                    arrayList.add(cell.getStringCellValue());
                }
                lists.add(arrayList);
            }
        }
        catch (Exception e) {
            this.logger.info("\u6279\u91cf\u6ce8\u518c\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
            return ErrorEnum.FILE_INFO_ERROR.resp(resp);
        }
        String userTypeStr = null;
        try {
            if (1 == userType) {
                userTypeStr = "\u4e2a\u4eba\u7528\u6237";
                result = this.personUserService.batchSavePersonUserByTemplateFile(lists);
            } else if (2 == userType) {
                userTypeStr = "\u673a\u6784\u7528\u6237";
                result = this.organUserService.batchSaveOrganUserByTemplateFile(lists);
            } else if (3 == userType) {
                userTypeStr = "\u8bbe\u5907\u7528\u6237";
                result = this.deviceUserService.batchSaveDeviceUserByTemplateFile(lists);
            }
        }
        catch (Exception e) {
            this.logger.error("\u6279\u91cf\u6ce8\u518c\u7528\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u6279\u91cf\u6ce8\u518c\u7528\u6237\u3010\u5931\u8d25\u3011\uff0c\u7528\u6237\u7c7b\u578b=").append(userTypeStr);
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.USER_MANAGER.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u6279\u91cf\u6ce8\u518c\u7528\u6237\u3010\u6210\u529f\u3011\uff0c\u7528\u6237\u7c7b\u578b=").append(userTypeStr);
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.USER_MANAGER.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("BaseUserController.batchUserByTemplateFile>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/status/{userId}/{status}"}, method={RequestMethod.GET})
    public Object updateUserStatus(@PathVariable int userId, @PathVariable int status, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("BaseUserController.updateUserStatus>>>>>>userId:" + userId + " status:" + status);
        if (0 != status && 1 != status) {
            this.logger.info("\u7528\u6237\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.baseUserService.updateUserStatus(Integer.valueOf(userId), status, false, null);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u7528\u6237\u72b6\u6001\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4fee\u6539\u7528\u6237\u72b6\u6001\u3010\u5931\u8d25\u3011\uff0c\u7528\u6237ID=").append(userId).append("\uff0c\u7528\u6237\u72b6\u6001=").append(status == 0 ? "\u6b63\u5e38" : "\u505c\u7528").append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.USER_MANAGER.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4fee\u6539\u7528\u6237\u72b6\u6001\u3010\u6210\u529f\u3011\uff0c\u7528\u6237ID=").append(userId).append("\uff0c\u7528\u6237\u72b6\u6001=").append(status == 0 ? "\u6b63\u5e38" : "\u505c\u7528");
        this.auditLogService.save(AuditLogOperatorTypeEnum.USER_MANAGER.type, logContent.toString(), logResult, bean.getSign());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/v1/user/template/{type}/{filename}"}, method={RequestMethod.GET})
    public Object downloadInfoFile(@PathVariable String filename, @PathVariable int type, HttpServletResponse resp) {
        this.logger.info("BaseUserController.downloadInfoFile>>>>>>filename:" + filename + " type:" + type);
        Result result = new Result();
        if (null == filename) {
            this.logger.info("\u4e0b\u8f7d\u5931\u8d25");
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        String path = PathConstants.BATCH_REGISTER_FILE_PATH;
        if (1 == type) {
            if (!("person_user_batch_register_template".equals(filename) || "organ_user_batch_register_template".equals(filename) || "device_user_batch_register_template".equals(filename))) {
                this.logger.info("\u4e0b\u8f7d\u5931\u8d25\uff0c\u6a21\u677f\u540d\u9519\u8bef");
                return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
            }
            this.logger.info("\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6");
        } else {
            if (2 != type) {
                this.logger.info("\u4e0b\u8f7d\u5931\u8d25,\u7c7b\u578b\u4e0d\u5b58\u5728");
                return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
            }
            path = PathConstants.BATCH_REGISTER_ERROR_FILE_PATH;
            this.logger.info("\u4e0b\u8f7d\u9519\u8bef\u6570\u636e\u6587\u4ef6");
        }
        filename = filename + ".xlsx";
        String filePath = path + filename;
        this.logger.info("=====================filePath :" + filePath);
        try {
            resp.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(filename, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.logger.info("\u4e0b\u8f7d\u6587\u4ef6\u7f16\u7801\u54cd\u5e94\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.FILE_ENCODE_ERROR.resp(resp);
        }
        ServletOutputStream out = null;
        FileInputStream fis = null;
        try {
            int len;
            out = resp.getOutputStream();
            File file = ResourceUtils.getFile((String)filePath);
            if (!file.exists()) {
                this.logger.info("\u6587\u4ef6\u4e0d\u5b58\u5728");
                ErrorBean errorBean = ErrorEnum.FILE_IS_NOT_EXIST.resp(resp);
                return errorBean;
            }
            fis = new FileInputStream(file);
            byte[] b = new byte[1024];
            while ((len = fis.read(b)) != -1) {
                out.write(b, 0, len);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.info("\u6587\u4ef6\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            ErrorBean errorBean = ErrorEnum.FILE_INFO_ERROR.resp(resp);
            return errorBean;
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
                if (null != fis) {
                    fis.close();
                }
            }
            catch (Exception e) {
                this.logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    @RequestMapping(value={"/v1/user/query/systemFlag"}, method={RequestMethod.GET})
    public Object querySystemFlag(HttpServletResponse resp) {
        Result result;
        this.logger.info("BaseUserController.querySystemFlag>>>>>>");
        try {
            result = this.baseUserService.getAllSystemName();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6ce8\u518c\u7528\u6237\u9009\u62e9\u7cfb\u7edf\u6807\u8bc6\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        this.logger.info("BaseUserController.querySystemFlag>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }
}

