/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.config;

import com.xdja.pki.backup.util.ConfigUtils;
import com.xdja.pki.cache.RedisClient;
import com.xdja.pki.core.constants.RedisKey;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.service.manager.system.SystemService;
import java.text.MessageFormat;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class InitRaInfo
implements CommandLineRunner {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    SystemService systemService;
    @Autowired
    private Environment environment;
    @Value(value="${system.flag}")
    private String systemFlag;
    @Autowired
    private RedisClient redisClient;

    public void run(String ... args) throws Exception {
        Constants.SYSTEM_DATABASE_TYPE = ConfigUtils.getSystemDatabaseType((Environment)this.environment);
        this.logger.info("\u6570\u636e\u5e93\u7c7b\u578b\u4e3a:{} \u83b7\u53d6\u6210\u529f\uff01", (Object)Constants.SYSTEM_DATABASE_TYPE);
        Config config = this.systemService.getConfigFile("config.json");
        if (0 != config.getInitStep()) {
            this.logger.info("\u5bc6\u7801\u673a\u5df2\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u52a0\u8f7dGMSSL\uff01");
            if (2 == CommonVariable.getIsHsm()) {
                GMSSLPkiCryptoInit.getSancHsmInstance();
            } else if (1 == CommonVariable.getIsHsm()) {
                GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            }
        } else {
            this.logger.info("\u5bc6\u7801\u673a\u6682\u672a\u521d\u59cb\u5316\uff01");
        }
        String keyFormat = MessageFormat.format(RedisKey.SHIRO_SESSION, this.systemFlag) + "*";
        Set keysList = this.redisClient.getKeys(keyFormat);
        for (String key : keysList) {
            System.out.println(key);
            this.redisClient.del(new String[]{key});
        }
        String keyFormat1 = MessageFormat.format(RedisKey.SHIRO_CACHE, this.systemFlag) + "*";
        Set keysList1 = this.redisClient.getKeys(keyFormat1);
        for (String key : keysList1) {
            System.out.println(key);
            this.redisClient.del(new String[]{key});
        }
    }
}

