/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.auditlog;

import com.xdja.pki.auditlog.service.AuditorOperateLogService;
import com.xdja.pki.auditlog.service.bean.AuditorOperateLogResultEnum;
import com.xdja.pki.auditlog.service.bean.AuditorOperateTypeEnum;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.service.manager.auditlog.ArchiveConfigService;
import com.xdja.pki.ra.service.manager.system.bean.ArchiveConfigVO;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ArchiveConfigController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AuditorOperateLogService auditorOperateLogService;
    @Autowired
    private ArchiveConfigService archiveConfigService;

    @RequestMapping(value={"/v1/archiveconfig"}, method={RequestMethod.GET})
    public Object getArchiveConfig(HttpServletResponse resp) {
        Result result;
        try {
            result = this.archiveConfigService.getArchiveConfig();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6 \u5ba1\u8ba1\u53c2\u6570 \u914d\u7f6e\u4fe1\u606f \u5f02\u5e38");
            result = Result.failure((int)-1, (Object)"\u83b7\u53d6 \u5ba1\u8ba1\u53c2\u6570 \u914d\u7f6e\u4fe1\u606f \u5f02\u5e38");
        }
        try {
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6 \u5ba1\u8ba1\u53c2\u6570 \u914d\u7f6e\u4fe1\u606f \u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/archiveconfig/save"}, method={RequestMethod.POST})
    public Object saveArchiveConfig(@Valid @RequestBody ArchiveConfigVO archiveConfigVO, BindingResult bindResult, HttpServletResponse resp) {
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u4fdd\u5b58\u5ba1\u8ba1\u53c2\u6570\u914d\u7f6e\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (null == archiveConfigVO.getMaxAuditLogLimit() || null == archiveConfigVO.getAuditLogPeriod() || archiveConfigVO.getAutoArchiveFlag() == 1 && (null == archiveConfigVO.getAutoArchivePeriod() || null == archiveConfigVO.getAutoArchiveAgo())) {
            this.logger.debug("\u4fdd\u5b58\u5ba1\u8ba1\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u7a7a\u53c2\u6570\uff1a" + archiveConfigVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        StringBuffer auditContext = new StringBuffer();
        Result result = this.archiveConfigService.saveArchiveConfig(archiveConfigVO);
        try {
            int auditResult;
            if (result.isSuccess()) {
                auditResult = AuditorOperateLogResultEnum.SUCCESS.id;
                auditContext.append("\u5ba1\u8ba1\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\uff0c\u914d\u7f6e\u4fe1\u606f\uff1a").append(archiveConfigVO.toCNString());
            } else {
                auditResult = AuditorOperateLogResultEnum.FAIL.id;
                auditContext.append("\u5ba1\u8ba1\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff0c\u914d\u7f6e\u4fe1\u606f\uff1a").append(archiveConfigVO.toCNString());
            }
            try {
                boolean flag = this.auditorOperateLogService.saveAuditorOperateLog(AuditorOperateTypeEnum.CONFIG_AUDIT_PARAMS.type, auditContext.toString(), auditResult);
                if (!flag) {
                    this.logger.error("\u8bb0\u5f55\u5ba1\u8ba1\u5458\u4fdd\u5b58\u6216\u4fee\u6539\u5ba1\u8ba1\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u5ba1\u8ba1\u5458\u4fdd\u5b58\u6216\u4fee\u6539\u5ba1\u8ba1\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u5ba1\u8ba1\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }
}

